
import os
import sys
import string

import json
#import numpy as np
from array import array
from datetime import datetime
import xml.etree.ElementTree as etree
from xml.etree.ElementTree import SubElement
from utils import _make_path_relative
from utils import xml_indent
from keil import PACK_ROOT
from keil import PACK_ROOT_BUILD_TOOL
from keil import SCONSTRUCT_DIR
from keil import project_name
fs_encoding = sys.getfilesystemencoding()

def VSCodeAddGroupForFN(ProjectFiles, parent, name, filename, project_path):
    children = dict()

    children['ShortName'] = name
    children['Type'] = 'group'
    children['Path'] = os.path.abspath(name)
    parent.append(children)
    children['Children'] = list()
    fileChildren = dict()
    name = os.path.basename(filename)
    path = os.path.dirname (filename)

    basename = os.path.basename(path)
    path = _make_path_relative(project_path, path)
    path = os.path.join(path, name)
    name = os.path.basename(path)

    if name.find('.cpp') != -1:
        obj_name = name.replace('.cpp', '.o')
    elif name.find('.c') != -1:
        obj_name = name.replace('.c', '.o')
    elif name.find('.s') != -1:
        obj_name = name.replace('.s', '.o')
    elif name.find('.S') != -1:
        obj_name = name.replace('.s', '.o')
    else:
        obj_name = name

    if ProjectFiles.count(obj_name):
        name = basename + '_' + name
    ProjectFiles.append(obj_name)
    fileChildren['Path'] = path.decode(fs_encoding)
    fileChildren['Type'] = 'file'
    children['Children'].append(fileChildren)
    fileChildren['ShortName'] = name.decode(fs_encoding)

    return children

def VSCodeAddLibToGroup(ProjectFiles, group, name, filename, project_path):
    name = os.path.basename(filename)
    path = os.path.dirname (filename)

    basename = os.path.basename(path)
    path = _make_path_relative(project_path, path)
    path = os.path.join(path, name)

    filesnode = dict()
    name = os.path.basename(path)
    if name.find('.cpp') != -1:
        obj_name = name.replace('.cpp', '.o')
    elif name.find('.c') != -1:
        obj_name = name.replace('.c', '.o')
    elif name.find('.s') != -1:
        obj_name = name.replace('.s', '.o')
    elif name.find('.S') != -1:
        obj_name = name.replace('.s', '.o')
    else:
        obj_name = name

    if ProjectFiles.count(obj_name):
        name = basename + '_' + name
    ProjectFiles.append(obj_name)
    filesnode['Type'] = 'file'
    filesnode['ShortName'] = name.decode(fs_encoding)
    filesnode['Path'] = path.decode(fs_encoding)
    return group

def VSCodeAddGroup(ProjectFiles, parent, name, files, project_path):
    # don't add an empty group
    if len(files) == 0:
        return
    children = dict()

    children['ShortName'] = name
    children['Type'] = 'group'
    children['Path'] = name
    parent.append(children)
    children['Children'] = list()
    for f in files:
        fn = f.rfile()
        name = fn.name
        path = os.path.dirname(fn.abspath)

        basename = os.path.basename(path)
        path = _make_path_relative(project_path, path)
        path = os.path.join(path, name)
        #fileChildren=dict()
        #children['Children'] = list()

        fileChildren = dict()
        obj_name = ''
        name = os.path.basename(path)
        fileChildren['ShortName'] = name
        if name.find('.cpp') != -1:
            obj_name = name.replace('.cpp', '.o')
        elif name.find('.c') != -1:
            obj_name = name.replace('.c', '.o')
        elif name.find('.s') != -1:
            obj_name = name.replace('.s', '.o')
        elif name.find('.S') != -1:
            obj_name = name.replace('.s', '.o')

        if ProjectFiles.count(obj_name):
            name = basename + '_' + name
        ProjectFiles.append(obj_name)
        fileChildren['Path'] = path
        fileChildren['Type'] = 'file'
        children['Children'].append(fileChildren)
    return children

# The common part of making vscode project
def NewVSCodeProject(tree, target, script):
    project_path = os.path.dirname(os.path.abspath(target))
    tr_Dic = dict(tree)
    out = open(target, 'w')

    CPPPATH = []
    CPPDEFINES = []
    LINKFLAGS = ''
    CCFLAGS = ''
    ProjectFiles = []

    # add group
    groups = tr_Dic['ESTree']['Children']
    tr_Dic['ESTree']['ShortName'] = os.path.basename(target)
    tr_Dic['ESTree']['Path'] = os.path.abspath(target)
    tr_Dic['ESTree']['Type'] = 'project'
    #groups.clear() # clean old groups
    #del groups
    for group in script:
        group_tree =VSCodeAddGroup(ProjectFiles, groups, group['name'], group['src'], project_path)

        # for local CPPPATH/CPPDEFINES
        if (group_tree != None) and ('LOCAL_CPPPATH' in group or 'LOCAL_CCFLAGS' in group or 'LOCAL_CPPDEFINES' in group):
            if 'LOCAL_CPPDEFINES' in group:
                tr_Dic['GCCCDefine']     = ', '.join(set(group['LOCAL_CPPDEFINES']))
            else:
                 tr_Dic['GCCCDefine']     = ' '
            tr_Dic['GCCCUndefine'] = ' '

            if 'LOCAL_CPPPATH' in group:
                tr_Dic['GCCCInclude'] = ';'.join([_make_path_relative(project_path, os.path.normpath(i)) for i in group['LOCAL_CPPPATH']])
            else:
                tr_Dic['GCCCInclude'] = ' '
                # get each include path
        if 'CPPPATH' in group and group['CPPPATH']:
            if CPPPATH:
                CPPPATH += group['CPPPATH']
            else:
                CPPPATH += group['CPPPATH']

        # get each group's definitions
        if 'CPPDEFINES' in group and group['CPPDEFINES']:
            if CPPDEFINES:
                CPPDEFINES += group['CPPDEFINES']

            else:
                CPPDEFINES = group['CPPDEFINES']

        # get each group's link flags
        if 'LINKFLAGS' in group and group['LINKFLAGS']:
            if LINKFLAGS:
                LINKFLAGS += ' ' + group['LINKFLAGS']
            else:
                LINKFLAGS += group['LINKFLAGS']

        if 'LIBS' in group and group['LIBS']:
            for item in group['LIBS']:
                lib_path = ''
                for path_item in group['LIBPATH']:
                    full_path = os.path.join(path_item, item + '.lib')
                    if os.path.isfile(full_path): # has this library
                        lib_path = full_path
                        break

                if lib_path != '':
                    if group_tree != None:
                        VSCodeAddLibToGroup(ProjectFiles, group_tree, group['name'], lib_path, project_path)
                    else:
                        group_tree = VSCodeAddGroupForFN(ProjectFiles, groups, group['name'], lib_path, project_path)

    # write include path, definitions and link flags
    tr_Dic['GCCCInclude'] = ','.join([_make_path_relative(project_path, os.path.normpath(i)) for i in CPPPATH])
    tr_Dic['GCCCDefine'] = ', '.join(set(CPPDEFINES))
    tr_Dic['Misc'] = LINKFLAGS

    json_conversion = json.dumps(list(tr_Dic.items()),skipkeys="true",indent=4)
    out.write(json_conversion)
    out.close()

def VSCodeProject(target, script):
    template_path = PACK_ROOT_BUILD_TOOL + '/template.escfg'
    #template_json = json.load(open(template_path,'r'))
    with open(template_path, 'r') as json_file:
        template_json = json.load(json_file)
    NewVSCodeProject(template_json, target, script)




