# ES32 SDK Release Note

[TOC]

## V1.31 2025-11-14

### ES32F0283

1. 上电初始化时钟函数 md_rcu_sys_init 新增对HRC48M阶梯升频的支持。

## V1.30 2025-11-04

### ES32F0283

1. 修复adc offset例程的零点漂移bug；
2. 新增msc_spiflash_fatfs_pdf例程；
3. 优化md_rcu.c，提高系统时钟的稳定性。

### ES32M0502

1. 修订CAN例程中的波特率注释错误。

### ES32F361x_362x

1. ES32F361x_362x增加UART_BOOT/LiteOS例程；
2. ES32F361x_362x解决串口全双工通信收发冲突问题；

### ES32F36xx/ES32F336x

1. ES32F36xx/ES32F336X解决串口全双工通信收发冲突问题；

### ES32F065x

1. ES32F065x解决串口全双工通信收发冲突问题；

### ES32H040x/FS040

1. ES32H0403/FS040中修正IO中断清除标志的操作错误；

2. ES32H0403/FS040中解决串口全双工通信收发冲突问题；

## V1.29 2025-07-15

### ES32F361x_362x

1. ES32F361x_362x的MD MSC例程中增加数据FLASH的操作例程;
2. ES32F361x_F362x的ald_adc.c中校准函数修订;

### ES32M0502

1. 新增两个CMP例程：负端参考为VRES1，VINN为内部参考电压VRESINT；
2. 新增LIN主机/从机demo；
3. Timer通道输出demo增加输出比较预载使能；
4. demo里的模拟引脚改为浮空；
5. 补充coremark例程；
6. 修订md_dma.h里的枚举错误，MD_DMA_MSIGSEL_UART2_TX = 1U。

### ES32F010x

1. I2C结构体初始化函数md_i2c_struct_init补充参数dual_addr和own_addr2的初始化配置；
2. Timer通道输出demo增加输出比较预载使能；
3. demo里的模拟引脚改为浮空；
4. md_adc.h增加单次模式重新使能和连续模式重新使能内联函数。

### ES32F0283

1. 新增ADC零点偏移校准例程。

### ES32H040x

1. ADC ald库增加当前系统供电电压计算函数
2. GPIO ald库修改管脚电平输出寄存器操作方式

### FS040LQ

1. 新增料号FS040LQ

## V1.28 2025-03-20

### ES32F065x

1. ES32F065x的ald_uart.c中ald_uart_irq_handler函数中接收先清标志；

### ES32F361x_362x

1. ES32F361x_362x/Startup中的gcc启动文件作修订；
2. ES32F361x_F362x/Include/ald_adc.h 文件中高速模式和低速模式的修改；
3. ES32F361x_362x的Projects下增加Templates_ALD;
4. ES32F361x_362x中ALD的SPI例程中增加SPI显示例程；

### ES32M0502

1. 重构MD库和所有例程。

### ES32F010x

1. 优化es32f010x.h，补全遗漏的“extern "C" {”。
2. 优化函数md_pmu_sleep_enter，该函数禁止深睡眠模式。



## V1.27 2025-01-09

### ES32F361x_362x

1. SPI的ALD例程中增加外部FLASH四线查询模式例程；
2. ADC的ALD例程中增加ADC的温感例程；
3. UART的ALD例程中增加超时接收不定长数据例程；
4. 优化了ADC的修调及温感转换函数。

### ES32F36xx/ES32F336x

1. ADC的md_adc.c中修订md_dma_disable()函数；

### ES32F0283

1. 修正md_utils.h/md_utils.c里UID相关接口的错误。

### ES32F010x

1. 修正md_timer.c里ic4_config函数寄存器错误；
2. 将内联函数md_gpio_toggle_pin_output里的读、修改、写寄存器操作改为直接写寄存器操作；
3. md_pmu_sleep_enter和md_pmu_stop_enter函数增加操作：休眠前暂停SysTick计数，退出休眠后再恢复SysTick计数状态；
4. 使能ADC_CON1_DMA的函数，函数名由md_adc_set_overflow_detection_state_ovrdis改为md_adc_dma_enable；
5. 所有USART例程，将清除IDLE标志位的操作由中断服务函数中移至主循环中。

### Book2_Example

1. 修复ES32F0283 FreeRTOS例程编译错误的问题。



## V1.26 2024-11-11

### ES32F361x_362x

1. 优化UART的中断函数中接收数据和发送数据的处理；
2. 修订ADC时钟分频的显示错误；
3. 增加UART接收不定长数据例程；
4. 增加ADC的补偿接口；
5. 更新UART/LPUART的各个例程；
6. 修订utils文件中UID的错误。

### ES32H0403

1. 优化UART的中断函数中接收数据和发送数据的处理。

### ES32F36xx/ES32F336x

1. 优化UART的中断函数中接收数据和发送数据的处理。

### ES32F065x/ES32F033x

1. 优化UART的中断函数中接收数据和发送数据的处理。

### ES32F010x

1. 修正md_timer_get_break_valid_interrupt_flag_brkim操作的寄存器为TIMER_IFM_BRKIM；
2. AD16C4T\03_capture例程优化：主循环中增加DMA状态6处理机制，防止发生状态6死锁问题；
3. 优化md_syscfg.h部分内联函数名称。

### Book2_Example

1. 修复FreeRTOS例程的中断在FreeRTOS初始化前调用的问题。




## V1.25 2024-09-10

### ES32F361x_362x

1. 初版发布

### ES32H0403

1. 增加例程：uart_boot，配合UART_BOOT上位机使用；
2. 增加例程：TK_example，在原触控例程基础上优化结构，添加增强滤波算法。

### ES32F010x

1. 优化I2C从机例程：收到stop信号后，判断RXNE标志位，再读取接收数据；
2. 将GPIO的FUNC配置提到MODE配置之前；
3. 优化模拟EEPROM例程03_flash_emulate_eeprom：简化页状态的判断。

### ES32F0283

1. 增加例程：温度补偿HRC4M时钟；
2. assert_param(ALD_IS_TIMER_CC2_INSTANCE(TIMx))增加判断C4定时器；
3. 删除ALD库及其例程（USB相关库和例程除外）。

### ES32F0271

1. 删除ALD库及其例程（USB相关库和例程除外）。

### ES32F0943

1. 删除ALD库及其例程。

### ES32F0930

1. 删除ALD库及其例程。

### ES32M0502

1. 删除ALD库及其例程。

### Book1_Example

1. 将所有DMA中断服务程序里的标志位嵌套判断改为独立判断；
2. 将DMA相关例程改成只在初始化时清零一次g_dma0_ctrl_base结构体；
3. 优化模拟EEPROM例程03_flash_emulate_eeprom：简化页状态的判断。

### Book2_Example

1. 将MicroBoot的APP demo通信协议改为单发单收协议；
2. 新增例程adpcm_i2s，通过i2s播放adpcm解码的音频；
3. 升级pwm_dac_adc例程，添加播放adpcm编码的音频的功能。



## V1.24 2024-02-04

### ES32F36xx

1. ES32F36xx的ald_cmu.c文件中增加HRC自校准参数装载函数；
2. ES32F36xx的md_adc.h函数中md_adc_set_normal_11st_conv_ns11函数修订。

### ES32H040x

1. ES32H040x ald_gpio.c文件中ald_gpio_exti_clear_flag_status函数修订；
2. 修订ES32H040x md_gpio.h的md_gpio_clear_flag函数。

### ES32F0283

- Driver : 

1. retarget.c: 優化，keil勾選或不勾選"Use MicroLIB" printf皆可使用；
1. md_rcu.c、ald_rcu.c：加入系統階梯式升降程序，調整時鐘開關順序。

- Application:

1. 新增例程(Application): coremark/dhrystone

- Project:

### ES32F0943

- Driver : 

1. retarget.c: 優化，keil勾選或不勾選"Use MicroLIB" printf皆可使用
2. startup_es32f0943.s: Stack_Size修正

- Application: coremark/dhrystone

- Project:

### ES32F0930

- Driver : 

1. retarget.c: 優化，keil勾選或不勾選"Use MicroLIB" printf皆可使用
2. 修改註解: md_syscfg.h

- Application:

- Project:

1. MD MMC例程:ADC_Constant_current_measurement/ADC_Example/ADC_Example_By_IT/ADC_Tempture，刪除多餘設定

### ES32M0502

- Driver : 

1. #define修改enum並統一命名方式: md_timer.h / md_opamp.h / md_pi.h / md_sva.h / md_vres.h / md_wwdt.h / md_dma.h / md_adc.h / md_can.h / md_i2c.h / md_iir.h / md_spi.h
2. md_xxx.h修改同步修改: md_can.c / md_dma.c / md_i2c.c / md_iir.c
3. md_uart.h:新增中斷缺少的function
4. md_dma.h/md_dmamux.h: 合併兩個檔案，並刪除md_dmdmux.h
5. md_adc.h: 修改md_adc_watchdog_channel enum數值
6. md_fc.h :修改錯誤function
7. md_sva.h :修改錯誤function
8. 優化所有檔案格式: 創建MD User Manual使用 / 創建ALD User Manual使用
9. ald_timer.h / ald_timer.c : 修正缺少設定
10. retarget.c: 優化，keil勾選或不勾選"Use MicroLIB" printf皆可使用

- Application:

1. 新增例程(Application): coremark / dhrystone

- Project:

1. SVA_export_timer_pwm_by_dma: 同步md_sva.h修改
2. Driver合併同步更新所有例程: md_dma.h/md_dmamux.h合併，project中刪除md_dmamux.h
3. ADC_Conversion_TriggerTimer_DMA/ADC_SingleConversion_TriggerSW_DMA: 更新driver，同步更新例程

### Book1_Example

1. 新增通过PIS连接UART TX/RX到IO的例程；

2. 新增通过PIS连接IO到IO的例程。

### Book2_Example

1. 新增 uart 1k xmodem模式的bootloader，并支持两个版本：backup_boot(单备份app)和no_backup_boot(无备份app)；
2. 将原有的micro_boot的bootloader程序放入no_backup_boot；
3. 添加M3内核定点DSP库并在Book2中新增对应例程。

## V1.23 2023-12-11

### ES32F010x
- Driver : 
1. 修订ES32F010x中GPIO的ALD/MD清外部中断标志位函数;

### ES32F040x
- Driver : 
1. 修订ES32H040x中GPIO的ALD/MD清外部中断标志位函数;

### ES32F0283

- Driver : 

1. ald_cmp.h: 修改定義字名稱
2. md_cmp.h: 修改定義字名稱
3. md_syscfg.h: 修改定義字名稱
4. md_dma.c: 增加設定，確保主要交替轉換模式

- Application:

1. 新增例程(Application): 04_mscbldr(通过MSC设备连接电脑USB口方式更新APP)

- Project:

1. 新增例程(MD): EXTI_lvd，lvd發生產生exti中斷
1. 更新例程(MD): CMP_Example_interrupt，IAR工程名稱修正
3. 新增例程(MD): CMP_Example_interrupt(VRES)，CMP使用內部VRES比較    
4. 更新例程(MD): DMA_mem_to_mem_Scatter-aggregate，優化設定
5. 新增例程(MD): DMA_I2S_Scatter-aggregate，I2S使用DMA分散聚集模式  
6. 新增例程(MD): ADC_Temperature，溫度量測   

### ES32F0943

- Driver : 

1. 移除 IA_VCMS 以及 ADC_VCMS 暫存器描述以及 register map
2. reg_adc.h
3. reg_anpwr.h
4. 更新keil和iar啟動文件(startup_es32f0943.s)：增加配置字反碼邏輯檢查
5. md_adc.c/md_adc.h
6. md_anpwr.h

- Application:

- Project:

1. 新增例程(MD): EXTI_lvd，lvd發生產生exti中斷
1. 移除 IA_VCMS 以及 ADC_VCMS 暫存器描述以及 register map，並同步修改ADC例程
1. 新增(MD): ADC_Example_VDDA

### ES32F0930

- Driver : 

1. 更新keil和iar啟動文件(startup_es32f0930.s)：增加配置字反碼邏輯檢查
2. 修改註解: md_syscfg.h

- Application:

- Project:

1. 新增例程(MD): EXTI_lvd，lvd發生產生exti中斷

### ES32M0502

- Driver : 

1. 新增: ald.can.c/ald.can.h
2. 新增修改: md.can.c/md.can.h
3. reg_adc.h，修正暫存器錯誤
4. 更新keil和iar啟動文件(startup_es32m0502.s)：增加配置字反碼邏輯檢查
5. . md_adc.c/md_adc.h
6. md_can.c/md_can.h
7. md_i2c.c/md_i2c.h
8. md_rcu.c/md_rcu.h
9. md_gpio.h
10. md_uart.h
11. md_calc.h/md_can.h/md_cmp.h/md_i2c.h/md_iir.h/md_spi.h/md_iwdt.h/md_syscfg.h/md_can.c/md_i2c.c: #define修改enum

- Application:

1. 更新_IEC60730_ClassB_v1.0例程

- Project:

1. 新增例程(MD): EXTI_lvd，lvd發生產生exti中斷
2. MD/ALD: CAN_rx/CAN_tx/CAN_tx_loopback/CAN_tx_loopback_rx_by_it/CAN_tx_loopback_rx_filter_fifo0_fifo1
3. 新增(MD): ADC_AutoInject_DMA/ADC_ContinueConversion_GroupsRegularInject_DMA/ADC_Dual_InjectSimultaneous/ADC_Dual_RegularSimultaneous/ADC_Example_AWD/ADC_GainCompensation/ADC_OffsetCompensation/ADC_Oversample_DisTriggerMode/ADC_SingleConversion_TriggerTimer_IT/ADC_TemperatureSensor
4. 更新(MD): CMP_Example，腳位錯誤修正
5. 更新(MD): CMP_Example_interrupt，腳位錯誤修正
6. 更新(MD): Sleep_Wakeup_from_Button，設定錯誤修正

### Middlewares:

1. 优化micro_boot中间件及其例程

2. CherryUSB协议从v0.7.0更新到v0.10.1，并适配相关例程

   

## V1.22 2023-10-31

### ES32F36xx/ES32F336x

1. ES32F36xx/ES32F336x的ald_cmu.c文件中增加3V3/5V时HRC的校准值接口函数； 

2. ES32F36xx/ES32F336x增加及修改iwdt/wwdt的no reset函数 ;

3. ES32F36xx/ES32F336x的3.3V HRC 校准值写入有效寄存器函数更新；
4. ES32F36xx/ES32F336x的MD CRC接口中修复相关错误；

### ES32H040x

1. ES32H040x 增加及修改iwdt/wwdt的no reset函数 ;
2. ES32H040x ald_rmu.h文件中增加复位枚举 ;
3. ES32H040x 的MD CRC接口中修复相关错误；


### ES32F0283

- Driver : 

1. 更新retarget.c for iar 9.4 printf
2. md_i2c.h : 根據型態新增增加暫存器function / 修正md_i2c_handler_transfer function
3. md_i2c.c : 優化function
4. md_fc.c / ald_fc.c : 新增設定，確保操作區域正確

- Application:

1. bootloader readme說明更新
1. 根据最新的0283的启动文件的修改，更新FreeRTOS例程中相应的部分

- 例程:

1. MD: CMP_Example_interrupt，cmp使用中斷

### ES32F0943

- Driver : 

1. ald_adc.h: 修改定義名稱Driver MD(優化)
2. ald_anpwr.h : 移除 VBG_TSFLTEN 相關設定 / 移除VBG 溫度感測腳位 RC 濾波器開關函數設定
3. 更新retarget.c for iar 9.4 printf
4. md_adc.h: 修改定義名稱
5. md_i2c.h : 根據型態新增增加暫存器function / 修正md_i2c_handler_transfer function
6. md_i2c.c : 優化function
7. md_opamp.h: 修改定義字名稱
8. md_fc.c/md_fc.h: 新增讀取optionbyte溫度function
9. md_fc.c / md_fc.h : 修改定義字名稱//新增設定，確保操作區域正確
10. ald_fc.c / ald_fc.h : 修改定義字名稱//新增設定，確保操作區域正確

- Application:

1. 新增HRC_trimming_by_losc例程
1. bootloader readme說明更新

- Project:

1. 新增例程 : ADC_Constant_current_measurement
2. 更新例程 : ADC_BIQ_Example/ADC_Example/ADC_IA_Example/ADC_NoiseFreeBit，刪除多餘腳位設定
3. 新增例程: ADC_Tempture
4. 新增例程: CMP_Example_interrupt，cmp使用中斷

### ES32F0930

- Driver : 

1. 更新retarget.c for iar 9.4 printf
1. md_mmc.h修改定義字
1. md_fc.c : md_fc_read_adc_temperature_voltage，電壓改為3V
1. ald_fc.c : 新增設定，確保操作區域正確
1. reg_mmc.h : 暫存器欄位名稱修改  
1. md_fc.c : 新增設定，確保操作區域正確
1. md_mmc.h : 暫存器欄位名稱修改，同步修正    
1. md_rcu.c:刪除多餘function

- Project: 

1. 新增MMC例程函數: VCM引腳初始化，MMC MD例程同步更新
2. 新增: TIMER_MasterSlave_frequency_sample
3. 優化: TIMER_output，刪除多於設定
4. 修改MMC例程函數: VCMInit改成ACMInit(引腳名稱為ACM)
5. 例程更新，MMC例程更新設定
6. MD:RCU_ClockConfig，刪除多於程序

- Application:

1. bootloader readme說明更新

### ES32M0502

 初版上傳

### ES32F010x

- Driver

1. 修复“ES32F010x同时编译DMA和PIS模块单元报错”的bug
2. 修复md_crc_set_mode 不能设置CR寄存器中的mode值
3. 修复md_crc_get_mode 不能正确获取CR寄存器中的mode值
4. 修复md_crc_set_data_bits 不能设置CR寄存器中的bits值
5. 修复md_crc_get_data_bits 不能正确获取CR寄存器中的bits值
6. 修复md_crc_set_check_order 不能设置CR寄存器中的order值
7. 修复md_crc_get_check_order 不能正确获取CR寄存器中的order值



## V1.21 2023-07-07

### ES32F36xx/ES32F336x

1. Application中的boot例程增加CRC校验；
2. CRYPT的中断interrupt_config函数中，先清中断标志，再使能中断；

### ES32F065x/ES32F033x

1. UART使用流控时，uart_init函数关闭FIFO功能；

2. CRYPT的中断interrupt_config函数中，先清中断标志，再使能中断；

### ES32H040x

1. 修改函数ald_acmp_init中INPUTSEL寄存器赋值方式
2. 增加TK应用例程（TK中断方式）
3. 修改PWM输出例程的空闲电平状态
4. 修正ALD库USART例程04_recv_frame无法接收问题
5. 修正MD库UART例程send_recv_by_interrupt时钟未初始化等问题

### ES32F010x

1. ES32F010x PMU例程新增“休眠下WWDT秒唤醒例程（HRC校准LRC）demo”；
2. ES32F010x ADC例程新增“采样内部LDO 1.66V反推ADC参考电压demo”；
3. 删除Drivers/MD/ES32F010x/Include/type.h 中 BITBAND的相关定义。
4. 优化md_cmu.c中的时钟切换逻辑过程；
5. BootLoader例程增加App校验和合法性判断；
6. MSC例程新增“私有代码保护”例程和“内部Flash模拟E2RPOM”例程。


### ES32F0283

- Driver ALD:

1. ald_dma.c : 修復被優化後無法正常寫入特定暫存器問題(使用volatile)
2. ald_dma.c : 修復當使用者傳入n_minus_1=0時會影響到其他bit時的問題，使用mask及判斷式進行設定時修復，目前如果ald_dma_config_base函數中n_minus_1變數輸入為0時會寫入0到DMA的n_minus_1的暫存器內
3. ald_i2c.c/ald_i2c.h : 新增ald_i2c_clear_txbuff函數，用在使用DMA傳輸時遇到NACK時，資料會卡在TXDATA內時可以透過該函數流程清除TXDATA內的資料。
4. ald_adc.c : function錯誤修正
5. ald_fc.c : function錯誤修改
6. ald_dma.c:p->size判斷修正
7. ald_rcu.h : 暫存器錯誤修正
8. ald_i2c.c: ald_i2c_mem_write_by_it / ald_i2c_mem_read_by_it，function流程錯誤修改
9. 新增ald_usb.c/ald_usb.h

- Driver CMSIS:

1. reg_dma.h :定義字錯誤修改
1. reg_adc.h: 新增暫存器欄位
1. reg_rcu.h: 開放RCU->CKTRM HRC、HRC48相關欄位

- Driver MD:

1. md_dma.c : 修復當使用者傳入nbytes-1=0時會影響到其他bit時的問題，使用判斷式進行設定時修復，目前如果md_dma_init函數中nbytes-1變數輸入為0時會寫入0到DMA的nbyte-1的暫存器內
2. md_i2c.c/md_i2c.h : 新增md_i2c_clear_txbuff函數，用在使用DMA傳輸時遇到NACK時，資料會卡在TXDATA內時可以透過該函數流程清除TXDATA內的資料 / 修改錯誤。
3. md_iwdt.h : 刪除多餘設定
4. md_adc.c : function錯誤修正 / 新增function
5. md_calc.h : 新增function
6. md_rcu.c / md_rcu.h : 開放RCU->CKTRM HRC、HRC48相關欄位，並新增其設定function
7. md_i2c.h : 新增Nbyte設定function / 刪除多餘function
8. md_iwdt.h : 刪除多餘function
9. md_crc.c : 加入md_rcu.h標頭檔
10. md_i2c.c : 新增Nbyte設定function

- Project:

1. I2C_Master_TRx_By_IT/I2C_Slave_TRx_By_IT:中斷函數新增處理function
2. 新增/優化例程 ALD : I2C_eeprom_read_write_PDS_E2_FLASH_By_IT
3. 修正例程 MD : I2C_eeprom_read_write_PDS_E2_FLASH

- Middlewares:

1. 更新MicroBoot Driver: micro_boot.c/micro_boot.h
2. CherryUSB driver

- Application:

1. 新新增UART_Boot_app_demo : 配合UART_Boot例程透過上位機做跳轉

2. UART_Boot流程更新: 

   * 增加CRC判斷

   * 取消Boot pin使用

3. 更新USB例程:usbdev_hidbldr

4. _IEC60730_ClassB_v1.0移除多於檔案

5. 新增CherryUSB例程

### ES32F0943

- Driver ALD(優化)

1. ald_adc.h/ald_adc.c
2. ald_cmp.h / ald_cmp.c
3. ald_opamp.h / ald_opamp.c
4. ald_anpwr.h / ald_anpwr.c
5. ald_lcd.h / ald_lcd.c
6. ald_fc.h / ald_fc.c : function錯誤修改
7. ald_i2c.c: ald_i2c_mem_write_by_it / ald_i2c_mem_read_by_it，function流程錯誤修改
8. ald_adc.h : define字修正

- Driver MD(優化)

1. md_adc.h / md_adc.c
2. md_cmp.h / md_cmp.c
3. md_opamp.h / md_opamp.c 
4. md_anpwr.h  md_anpwr.c
5. md_lcd.h/md_lcd.c
6. md_i2c.h / md_i2c.c
7. md_calc.h : 新增functiuon
8. md_syscfg.h : 刪除多餘定義/ function錯誤修改
9. md_rcu.h : 新增HRC Trim暫存器

- Driver CMSIS:

1. 更新reg_anpwr.h:暫存器欄位名稱修改
2. reg_lcd.h: 修改暫存器名稱錯誤
3. reg_rcu.h: 刪除多餘暫存器，不開放
4. reg_opamp.h : 暫存器位置錯誤修改
5. 更新keil startup Driver: startup_es32f0943.s
6. reg_rcu.h : 暫存器欄位錯誤修正
7. reg_syscfg: 暫存器位元欄位錯誤修改
8. reg_rcu.h : 新增HRC Trim暫存器

- Project:

1. 新增ALD例程: ADC_BIQ_Example / LCD_example / ADC_IA_Example / ADC_Simple_Base_Example / OPAMP_CMP
2. 新增MD例程:  ADC_BIQ_Example / ADC_IA_Example / ADC_Simple_Base_Example / LCD_example / OPAMP_CMP / ADC_FreeNoiseBit
3. 更新所有例程for PDS: ES-PDS-ES32F0943LV-V0.01
4. . 刪除MD多餘project : TIMER

     優化UART打印介面(MD) : ADC/CALC/CMP/IWDT/UART/Timer/I2C/SPI

     修正顯示錯誤問題(MD): EXTI

     優化LED閃燈方式(MD) : GPIO

     擴充原始範例LCD(MD):可以連接PDS板上按鈕並切換LCD顯示，LCD可以顯示時鐘格式或純數字格式(有提供範例函數)

     擴充原始範例OPAMP(MD):將V+設為VREF(VBG), 透過Button 調整V-VDIV > VBG, (V-) VDIV < VBG 輸出不同的結果。

     優化UART打印介面(ALD) : ADC
5. 新增例程 LCD_clock_RTCwakeup_example
6. 新增例程 ALD : I2C_eeprom_read_write_PDS_E2_FLASH_M24C04-WMN6TP_By_IT
7. 優化使用者顯示
8. 新增例程/修正例程

     . 新增例程 ALD :ANPWR_Example

     . 修正例程 ALD : OPAMP_CMP

     . 新增例程 MD :ANPWR_Example

     . 修正例程 MD : OPAMP_CMP  

- Middlewares:

1. 更新MicroBoot Driver: micro_boot.c/micro_boot.h

- Application:

1. 新新增UART_Boot_app_demo : 配合UART_Boot例程透過上位機做跳轉

2. UART_Boot流程更新: 

   * 增加CRC判斷

   * 取消Boot pin使用

### ES32F0930

- Driver ALD

1. ald_i2c.c: function型態更新
2. utils.c: 支援compiler 5/compiler 6修改
3. ald_rcu.c: IAR Warring修正
4. 註解優化

- Driver MD:

1. md_lcd.c: driver更新/ IAR Warring修正
2. md_lcd.h: 暫存器數值錯誤修正
3. md_i2c.c / md_i2c.h: 更新
4. md_rcu.h: function名稱錯誤修改
5. md_mmc.h : function修改/新增function
6. md_lcd.h : 錯誤修改
7. md_fc.c/md_fc.h : 新增function
8. md_spi.h: 暫存器錯誤修改
9. md_timer.h : 新增刪除函數
10. md_uart.h : 暫存器錯誤修改

- Driver CMSIS:

1. 同時相容compiler 5/compiler 6

- Project:

1. 優化例程，同時相容compiler 5/compiler 6、PDS腳位更新
2. 新增ALD例程: I2C_memery_send_recv_by_poll
3. ALD例程interrupt.c新增__inc_tick()中斷函數
4. rebuild IAR工程(Warring處理)
5. 例程修正 : ADC_Example_By_IT
6. 更新MMC例程: ADC_Constant_current_measurement
7. 同步ES-PDS-ES32F0930LT-V1.0更新: ADC_Example / ADC_Example_By_IT
8. 新增/更新 MD MMC: ADC_Tempture

- Middlewares:

1. 更新MicroBoot Driver: micro_boot.c/micro_boot.h

- Applications:

1. Bootloader keil例程錯誤修改
2. 新增IAR bootloader例程
3. UART_Boot流程更新: 增加CRC判斷 / 取消Boot pin使用
4. 新新增UART_Boot_app_demo : 配合UART_Boot例程透過上位機做跳轉


### Book1_Example
1. MSC例程新增“私有代码保护”例程和“内部Flash模拟E2RPOM”例程。


### Book2_Example
1. Bootloader例程新增APP校验和合法性判断。




## V1.20 2023-03-07

### 中间件

1. 新增 CherryUSB 协议栈
2. 新增 LVGL8 GUI 图形库
3. 新增 Contiki-NG 操作系统

### ES32F010x

1. md_cmu.c 更新，当外部晶体高于 12M 时置位 HOSCFLYBPS@CMU_CLKENR
2. Examples_MD/MSC 中新增“私有代码保护”的例程
3. Examples_MD/MSC 中新增 “eFlash模拟E2PROM” 的例程

### ES32F040x

1. Examples_MD/MSC 中新增 “eFlash模拟E2PROM” 的例程
2. 修改LCD模块注释与宏定义
3. 修改IIC主模式接收收到NACK后的处理方式
4. 增加TK库串口宏定义选择
5. 更新TKTK库按键超时处理


### ES32F36xx

1. Applications/Performance 中新增 “CoreMark测试” 的例程
2. ES32F336x的ALD库中增加ald_can.h/ald_can.c文件
3. ES32F336x的Project工程中增加can外设的相关例程
4. es32f336x.h文件中增加can外设相关资源
5. 修订es32f336x.s启动文件中can外设的相关内容
6. ES32F3例程的systick中断优先级改为最低
7. 删除ES32F36x/ES32F336x中ald_cmu.c文件中ald_cmu_config()/ald_pll1_config()函数中的ald_delay_ms(1000);函数
8. usbd_audio.c文件中增加音频的输入/输出宏定义
9. ES32F36xx的例程中，UART的06例程中断中增加判断判断TBUSY
10. ES32F36xx MD的TIMER例程中增加输出PWM例程
11. ES32F3的TSENSE的例程中，将PCLK2的分频改为128

### ES32F028x

- Driver ALD:

1. ald_dma.h : struct名稱新增
2. ald_rcu.h : define定義錯誤修改、修改函數寫法(IAR warring)
3. ald_uart.h : define定義錯誤修改
4. ald_adc.c : function錯誤修改(ald_adc_normal_channel_config)
5. ald_dma.c : struct名稱新增同步修改driver、dma配置修改，使用word方式寫入
6. ald_gpio.c : 暫存器名稱錯誤修改
7. ald_uart.c : 優化function、修改dma function設定
8. utils.c : weak 改為 WEAK(compiler5與compiler6判斷用)
9. ald_i2c.c : 修改讀寫memory相關function、修改timeout function判斷方式
10. ald_i2c.h : 修改function傳入參數大小、新增I2C 72MHz Timing配置
11. ald_cmp.c : ald_cmp1_init/ald_cmp2_init function修改，只有在暫存器被lock且要重新設定暫存器時才將之做reset動作、新增ald_cmp_deinit function

- Driver MD:

1. md_dma.h : struct名稱新增
2. md_utils.h : weak 改為 WEAK(compiler5與compiler6判斷用)、修改函數型態
3. md_utils.c : weak 改為 WEAK(compiler5與compiler6判斷用)
4. type.h : compiler5與compiler6判斷版本
5. md_i2c.h : 修改function傳入參數大小、新增I2C 72MHz Timing配置
6. md_i2c.c : 修改timeout function判斷方式
7. md_rcu.c : 修改函數寫法(IAR warring)

- Driver CMSIS:

1. reg_xxx.h : 刪除#pragma anon_unions，compiler 6不支持
2. es32f0283 : compiler5與compiler6判斷版本
3. retarget.c : compiler5與compiler6判斷版本 / 刪除#include<rt_misc.h>定義 / weak 改為 WEAK(compiler5與compiler6判斷用)
4. 移除core_cm0.c
5. 移除rt_misc.h
6. es32f0283.h : 修改Cortex-M0中斷名稱
7. startup_es32f0283.s(iar/keil) : 修改Cortex-M0中斷名稱

- Project:

1. keil/IAR工程重新產生、ALD例程統一Uart設定、更新例程:TIMER_output_PWM_By_DMA
2. Project IRAM Size修改(16KByte)
3. 修改打印字錯誤(ADC_Example_AWD)/修改Uart無法打問題(TIMER_output_Trigger_ADC)
4. 修改DMA_mem_to_mem
5. 修改例程uart tx腳位基本設定
6. 根據driver修正同步修改，可同時支持compiler 5與compiler 6
7. 除core_cm0.c : 從project中移除，此檔案沒用到
8. 更新ALD/MD I2C例程: I2C_eeprom_read_write_PDS_E2_FLASH
9. 因修改Cortex-M0中斷名稱，同步修正MD/ALD所有例程
10. ALD DMA_ping_pong例程修正

- 新增例程

1. DMA_mem_to_mem_pingpong
2. DMA_mem_to_mem_Scatter-aggregate

- Middlewares

1. 更新USB Driver/移除多餘檔案

- Applications

1. 新增例程:PDS_DEMO
2. 同步修改_IEC60730_ClassB_v1.0/Bootloader/PDS_DEMO/USB例程，可同時支持compiler 5與compiler 6
3. 因修改Cortex-M0中斷名稱，同步修正所有例程

### ES32F094x

- Driver ALD

1. ald_adc.h: 定義字數值錯誤修改、新增function
2. ald_lcd.h: 暫存器數值錯誤修正
3. ald_rcu.c: pll設定流程修改、修改函數寫法(IAR warring)
4. ald_cmp.h: struct新增設定
5. ald_fc.h: 新增function
6. ald_rcu.h: 修改HOSC default(8000000)
7. ald_cmp.c: 修改function錯誤
8. ald_fc.c: 新增function
9. ald_uart.c: 中斷呼叫函數修改
10. utils.c: 新增compiler 6相容功能
11. ald_spi.h: 移除多餘設定
12. ald_i2c.c : 修改讀寫memory相關function、修改timeout function判斷方式
13. ald_i2c.h : 修改function傳入參數大小
14. md_adc.c : 新增暫存器設定

- Driver MD:

1. md_adc.h: 定義字數值錯誤修改、新增struct(未定)
2. md_lcd.h: 暫存器數值錯誤修正
3. md_rcu.c: pll設定流程修改
4. md_anpwr.h: function名稱錯誤修改
5. md_cmp.h: 暫存器定義錯誤修改
6. md_rcu.h: 新增訂義字
7. md_utils.h: 新增compiler 6相容功能、修改函數型態
8. type.h: 新增compiler 6相容功能、compiler 5/6判斷
9. md_utils.c: 新增compiler 6相容功能
10. md_i2c.h : 修改function傳入參數大小
11. md_i2c.c : 修改timeout function判斷方式

- Driver CMSIS:

1. 刪除led、button相關設定，因為PDS未確定
2. reg_cmp.h:暫存器定義錯誤修改
3. 移除多餘檔案、移除reg_xxx.h不符合compiler 6之語法

- Project:

1. 優化例程，同時相容compiler 5/compiler 6
2. 更新MD I2C例程: I2C_eeprom_read_write_PDS_E2_FLASH
3. 所有例程IAR工程rebuild，修正warring

- 新增例程

1. 新增ALD I2C例程: I2C_eeprom_read_write_PDS_E2_FLASH
2. 新增例程:ADC_Simple_Example

- Applications:

1. 優化例程，同時相容compiler 5/compiler 6

   

### Book1_Example

1. Examples_MD/MSC 中新增 “私有代码保护” 的例程
2. Examples_MD/MSC 中新增 “eFlash模拟E2PROM” 的例程



### Book2_Example

1. 新增 CherryUSB 协议栈例程
2. 新增 Contiki 6LoWPAN 例程
3. 新增 LVGL8 GUI 例程




## V1.19 2022-10-14





### ES32F3xxx

1. 恢复ES32F36x MD库中的md_flash.c和md_flash.h文件
2. 修订ES32F36xx/ES32F3366的PIS例程中，04例程中的pis_tim_start()/ADC0_Handler()函数中的相关bug
3. 修订ES32F36xx/ES32F336x的ma_dma_disable_channel()函数的SET_BIT改为WRITE_REG
4. 增加ES32F36xx/ES32F336x的ald_i2c.h/ald_i2c.c中增加seq相关接口
5. 修订ES32F36xx/ES32F336x的ald_i2c.c文件中ald_i2c_mem_write（）函数
6. 修订ES32F36xx/ES32F336x中，ald_cmu.c文件中ald_cmu_clock_config()/ald_cmu_pll1_config()函数
7. 修订ES32F36xx/ES32F336x中，ald_i2c.c文件中，i2c_speed_init()/ald_i2c_slave_send()/ald_i2c_slave_recv()/ald_i2c_mem_write_by_it()函数
8. 在ald_usb.c及.h文件中新增函数ald_usb_host_components_init及ald_usb_device_components_init分别用于usb主机及从机的底层初始化，usb_lowlayer_api.h中增加对这两个函数的映射。
9. 修改例程Projects/ES32F36xx/Examples_ALD/ADC/02_insert_normal_by_interrupt/Src/main.c源文件函数传参错误



### ES32F065x

1. 修订ES32F065x的ald_acmp.c文件中ald_acmp_init()函数初始化bug
2. 删除ES32F065x的ald_cmu.h文件中cmu_perh_t枚举中的CMU_PERH_ADC1
3. 删除ES32F065x的ald_rmu.h文件中rmu_perh_t枚举中的RMU_PERH_ADC1
4. 修订ES32F065x的ma_dma_disable_channel()函数的SET_BIT改为WRITE_REG
5. 修订ES32F065x的ald_acmp.c文件中ald_acmp_init()函数初始化bug
6. 删除ES32F065x的ald_cmu.h文件中cmu_perh_t枚举中的CMU_PERH_ADC1
7. 删除ES32F065x的ald_rmu.h文件中rmu_perh_t枚举中的RMU_PERH_ADC1



### ES32F040x

1. 修改时钟配置：当系统运行48M/32M主频时，APB2做2分频




### ES32F010x

1. 更新ES32F0100库函数，md_dma_disable_channel中存在的错误
2. 更新ES32F0100驱动库md_cmu.c，使ES32F0131可以正常使用48MHz时钟
3. 更新ES32F0100例程中05_send_recv_by_dma中存在的结构体初始化不完整的问题
4. ES32F0100例程包中I2C下新增例程06_i2c_sensor_ens210用于演示软件模拟I2C控制传感器



### ES32F028x

- Driver ALD:

1. ald_adc.c/ald_adc.h修改/ald_fc.c新增function
2. ald_i2c.h/ald_spi.h: 修正driver
3. ald_fc.c : function ald_fc_read()錯誤修正
4. ald_i2c.c : function 錯誤修正
5. ald_adc.c : 新增Calibration函數
6. ald_i2c.h修改

- Driver MD:

1. md_adc.h: function名稱修正/新增Caliration定義
2. md_exti.h: function修改
3. md_fc.h: 參考function新增
4. md_gpio.h: 定義錯誤修改
5. md_i2c.h: 刪除多餘function
6. md_adc.c: 新增Caliration函數
7. md_fc.c: function md_fc_read()錯誤修正
8. md_i2c.c: function md_i2c_master_send()修改
9. md_adc.c修正

- Driver CMSIS:

1. reg_calc.h : 位元數修改
2. reg_i2c.h : 刪除多於定義
3. reg_syscfg.h : 位元數修改
4. reg_timer.h : 位元數修改

- Project:

1. Project調整 IROM Size調整為正確的0x20000(128K)
2. MD/ALD ADC例程優化
3. MD Project新增BSP設定 / ALD Project修改中斷名稱

- 新增例程

1. MD:I2C_eeprom_read_write_PDS_E2_FLASH
2. MD:SPI_flash_read_write_PDS_E2_FLASH
3. MD:SPI_Send_Recv_By_DMA
4. ALD:ADC_insert_normal_by_interrupt
5. ALD:ADC_normal_multipe_channel_by_dma
6. ALD:ADC_timer_trigger_adc
7. ALD:ADC_timer_trigger_insert_multipe_channel
8. ALD:I2C_eeprom_read_write
9. ALD:I2C_eeprom_read_write_PDS_E2_FLASH
10. ALD:SPI_flash_read_write_PDS_E2_FLASH
11. ALD:Timer_ExternalSignal_Trig
12. ALD:Timer_GateMode_InternalTrig
13. ALD:Timer_Input_Capture
14. ALD:Timer_OnePluse
15. ALD:Timer_Output_Compare
16. ALD:Timer_Output_Interrupt
17. ALD:Timer_Trig_DMA
18. usbdev_hidenum_sleep_mode
19. usbdev_hidenum_stop_mode
20. UART_Boot:函式fsm_words_program修改
21. 新增低功耗例程: PWR



### Book2_Example

1. 增加小米iot demo
2. 移植rt-thread nano及相关例程到ES32H040x
3. 移植freeRTOS及相关例程到ES32F0283



## V1.18 2022-08-11

### ES32F3xxx

1. 修订ES32F3366的TIMER相关的Assert相关的错误
2. ES32F3系列的MD例程中，增加中断分组，默认Group2
3. 修改ES32F3中IIC 模块i2c_req_mem_write()函数中清Reload及Nbytes
4. FreeRTOS例程，irq.c文件中Systick中断函数中直接调用xPortSysTickHandler函数

### ES32F065x

1. 修改ES32F065xh中，md_i2c_clear_smbus_flag_alert()函数的SET_BIT改为CLEAR_BIT



### ES32H040x

1. TK例程增加低功耗按键配置
2. 低功耗例程增加shutoff模式
3. 修改IO驱动电流注释
4. 增加MD库的bypass函数
5. 增加针对PSD板的LED低功耗配置例程



### ES32F028x

**Driver ALD**

1. V2.0初版完成

**Driver MD**

1. md_adc.h: 新增define
2. md_rcu.h: 新增判斷
3. md_rcu.c: 更新function
4. md_rcu.h : struct新增LOSC/LRC判斷開啟欄位
5. md_utils.h : 新增，classB自檢庫使用
6. type.h : 新增，classB自檢庫使用
7. md_rcu.h : struct新增LOSC/LRC判斷開啟欄位，結構體修改，Driver同步修正
8. md_gpio.c : 修改#define錯誤
9. md_rcu.c : 修改等待HOSC ready的function,使用tick等待
10. md_i2c.h : 修改#define錯誤
11. md_uart.c : 修正function中for迴圈宣告變數
12. md_dma.c / md_dma.h: 新增DMA_init_typedef變數及.c內新增計算結束位址的函數
13. md_i2c.c / md_i2c.h : 新增master設定function
14. md_adc.h : 刪除不必要的定義
15. md_iwdt.h : function修正為使用32bit讀寫方式
16. md_usb.h : 修改 USB_RXTYPE.PROTOCOL & TEPN / 格式對照USB_TXTYPE

**Project**

1. ALD例程根據Driver修改同步修正
2. ADC例程 : 優化程式碼
3. RTC例程 : 新增RCU設定Struct欄位，開啟LOSC/LRC判斷
4. 新增例程 : ADC_Example_AWD
5. 新增例程 : ADC_Example_DMA&IT_to_stat_ADC_ICH
6. 新增例程 : I2C_Master_Rx_By_DMA / I2C_Master_Tx_By_DMA / I2C_Slave_Rx_By_DMA / I2C_Slave_Tx_By_DMA
7. 新增例程 : SPI_Send_Recv_By_DMA
8. 修正例程 : ADC_Example_DMA(同步md_dma.c/md_dma.h修改)
9. 修正例程 : AES_Example_By_DMA(同步md_dma.c/md_dma.h修改)
10. 修正例程 : CRC_Example_By_DMA(同步md_dma.c/md_dma.h修改)
11. 修正例程 : DMA_mem_to_mem / DMA_mem_to_uart / DMA_uart_to_mem(同步md_dma.c/md_dma.h修改)
12. 修正例程 : I2S_Send_Recv_By_DMA(同步md_dma.c/md_dma.h修改)
13. 修正例程 : TIMER_output_PWM_By_DMA(同步md_dma.c/md_dma.h修改)
14. 修正例程 : UART_Receive_By_DMA(同步md_dma.c/md_dma.h修改)
15. 修正例程 : EXTI_int
16. 修正例程 : IWDT_example調整流程

**Applications**

1. usbdev_composite / usbdev_dual_cdc刪除不合法的文字說明
2. 新增USB HOST例程
3. 新增classB自檢庫(_IEC60730_ClassB_v1.0)

**Driver CMSIS**

1. es32f0283.h: 修改timer定義部分，刪除定義字"ALD_USED"來使用區隔MD/ALD project的定義



### Middlewares

1. Middlewares/EastSoft‎/Bootloader/Library/中boot_fatfs.c文件中run_in_flash()函数更新
1. 更新HID Bootloader协议

### Book1_Example

1. spi、i2c、usart及lcd例程移植到ES32H040x
2. PMU移植到ES-PDS-ES32F3696LX开发板


### Book2_Example

1. 新增ES-DAP-Viewer的使用例程




## V1.17 2022-05-12

### ES32F336x

1. 增加ES32F3366例程及更新相关外设驱动。



### ES32F36xx/ES32F33xx

1. 删除ES32F36xx/ES32F39xx/ES32F336X/ES32F355x系列芯片的.s启动代码中,调用sys_config()和adc_config()函数部分的内容。



### ES32F028x

1. MD库修订:
md_dma.h/md_dma..c: 修復dma.c函數計算bug
md_uart.h/md_uart.c : 新加入使用字元陣列傳送和接收的function
md_aes.h : #define marcro修改
md_crc.h : 函數錯誤修正

2. reg_tick.h/reg_usb.h: 註解更新
3. iar/keil : startup_es32f0283.s,檔頭說明更新，修改中斷名稱UART3_IRQHandler -> UART3_AES_IRQHandler
4. s32f0283.h: 修改中斷名稱UART3_IRQHandler -> UART3_AES_IRQHandler

5. 新增例程
CRC_Example_By_DMA
CRC_Example_deal_with_block
UART_Array_Receive_Send_By_IT
Uart_Polling_array_trans_recv
UART_Receive_By_DMA
AES_Example_By_DMA
TIMER_output_PWM_By_DMA
TIMER_output_send_onepulse
6. 修改例程
ADC_Example_DMA : 更新程式碼
AES_Example : 移除多於配置
TIMER_output_Trigger_ADC : 增加inject設定
修改interrupt.c/interrupt.h : UART3_IRQHandler -> UART3_AES_IRQHandler




## V1.16 2022-04-28

### ES32F010x

1. 增加ADC的温感例程。
2. 修改基本定时器能够操作DFCSEL位的BUG。
3. 删除MD库adc模块驱动程序文件中函数md_adc_init()中开启OVRIE中断的操作；
4. 解决MD库acmp模块驱动程序文件中函数md_acmp_init()函数中，临时变量进行或运算前未进行初始化的问题；
5. md_msc.h，去除函数md_msc_code_erase_page的第三个参数；
6. IWDT例程，在调用md_iwdt_init函数前添加注意事项。



### ES32F040x

1. 增加1K Xmode Bootloader 例程；
2. 修正MD库中RTC设置时间日期后软复位值丢失的问题；
3. 修正MD库中FLASH页擦除页大小出误问题；
3. 修正结构体pmu_ldo_lpmode_output_t定义；
3. 增加配置寄存器 PMU->BKPCR0 时的解锁码0x5A00，否则无法正确写入配置；
6. 增加lpuart高速时钟例程；
7. TK例程增加注释；
7. 将部分例程的系统时钟改为HRC。



### ES32F028x

1. 新增Uart bootloader demo例程 : Applications\Bootloader\UART_Boot；

2. 新增PWM Trigger ADC例程 : Examples_MD\AD16C4T\AD16C4T_output_Trigger_ADC；

3. 新增ADC利用DMA傳輸例程 : Examples_MD\ADC\ADC_Example_DMA；

4. 新增USB例程: Applications\USB\usbapp\usbdev_cdc_composite；

5. md函数名统一整理，并同步修改例程，更新內容參照:
   [Projects\ES32F0283\ReleaseNote.html](Projects\ES32F0283\ReleaseNote.html)
   [Projects\ES32F0283\ReleaseNote.html](Projects\ES32F0283\ReleaseNote.html)
   [Projects\ES32F0283\ReleaseNote.html](Projects\ES32F0283\ReleaseNote.html)
   [Projects\ES32F0283\ReleaseNote.html](Projects\ES32F0283\ReleaseNote.html)

6. 修改md_dma.h/md_rcu.h/md_spi.h:
   md_dma.h：将原本channel enable，disable，swrequest的写法从SET_BIT改成WRITE_REG
   md_rcu.h：新增I2S相关设定
   md_spi.h：新增I2S相关设定
   reg_dma.h:更新寄存器列表
   md_dma.h:新增I2S相关设定
   reg_spi.h / es32f0283.h:新增I2S相关设定

7. 例程修改/新增：
   ADC_Example_DMA：优化function使用方式
   CALC_Div：修改运算数值
   CALC_SquareRoot：更改project名称，并修改运算数值
   CMP_Example：更新判断条件
   CRC_Example：加入计算用数组，并使用计算数组实现CRC功能
   DMA_mem_to_mem：使用数组做为目标地址和起始地址
   EXTI_int：修正程式判断逻辑
   WWDT_example / WWDT_example_it：删除多余配置
   ADC_Example_DMA：代码更新
   CMP_Example：新增注释
   FC_Read_Protect：代码更新
   I2S_Send_Recv：代码及注释更新
   I2S_Send_Recv_B_DMA：代码及注释更新
   WWDT_example：代码更新
   新增WWDT_example_it示例
   新增usbdev_cdcenum示例
   新增usbdev_composite示例
   新增usbdev_dual_cdc示例
   新增usbdev_hidbldr示例
   新增usbdev_hidenum示例
   新增usbdev_mscbldr示例
   新增usbdev_printer示例
   
   
   

### ES32F36xx/ES32F33xx

1. 删除ald_adc_init()函数中的默认开启OVRIE中断；
2. ald_acmp_init()函数中，补充变量赋初值；
2. md函数名统一整理。



### Book1_Example

1. 添加两个USB模块例程；
2. IWDT例程，在调用md_iwdt_init函数前添加注意事项。



### Book2 Example

1. Bootloader中IIC_Boot、SPI_Boot、UART_Boot例程的工程中添加md_cmu.c，删除main.c中系统时钟配置相关的函数和变量，系统时钟改为PLL 72MHz，并更新对应的readme.txt。
2. 增加ES-DAP-Viewer例程



## V1.15 2022-02-08

### ES32H040x

1. 修正部分MD例程编译报错问题；
2. 增加部分例程IAR支持；
3. 新增ES32H040x 性能测试Demo；
3. **修正当软件复位发生时RTC模块time和date数据丢失问题；**
3. **修正IAP页擦除操作页大小与寄存器设置不匹配的问题。**



### ES32F010x

1. 修改WWDT为中断清狗方式；
2. 补充Timer库缺失的内联函数；
3. 增加Timer清除比较输出的例程；
4. 增加ADC 1次标准转换后自动3次插入转换并循环的例程；
5. 增加ADC DMA pingpong模式例程；
6. 修改010x库函数头文件md_pis.h，删除md_pis_trig_t中无效的枚举值；
7. 修改iar和keil的启动文件，在启动文件中实现hardfault_handler并全局声明，修改所有例程的irq.c删除hardfault中断服务程序；
8. 修改所有涉及dma的例程，使之可以循环运行；
9. 修改md_wwdt.h，删除无窗口的枚举值；
10. 修改md_cmu.h文件中函数md_cmu_clock_config，在使用48M时钟或52M时钟时，旁路时钟滤波器，修复flash等待的问题；
10. **调整flash_read_write例程，使其调用库函数进行IAP操作；**
10. **修改md_utils.h中的UID和CHIPID地址错误；**
10. **修改md_pis.h中的md_pis_trig_t的错误。**



### ES32F028x

1. reg_cmp.h : 修改寄存器位名称；
2. md_gpio.c : 删除多余函数；
3. md_i2c.c : 函数错误修正；
4. md_rcu.c : 函数错误修改；
5. md_spi.c : 修改函数名称；
6. md_cmp.h : 修改寄存器位名称；
7. md_exti.h : 修改函数定义；
8. md_gp16c2tn.h : 新增define定义；
9. md_gp16c4tn.h : 修改define错误定义；
10. md_gp32c4t1.h : 修改define错误定义；
11. md_gpio.h : 修改define定义；
12. md_spi.h : 格式调整；
13. MD全部例程新增应用于PDS板的相关設定；
14. DMA例程:新增DMA_mem_to_uart / DMA_uart_to_mem；
15. 新增MD例程: Timer ETR例程(AD16C4T1/GP32C4T1/GP16C4Tn)；
16. USB例程更新HID_Bootloader通信协议；
17. SPI例程: 新增SPI_36MHz_读写flash_AT25DF081A-SH-T；
18. **修改USB project keil pack設定；**
19. **更新md_dma.h(新增function)。**



### ES32F36xx

1. ald_wdt.c文件中ald_wwdt_feed()修改函数；
2. ald_rtc.c文件中ald_rtc_get_flag_status()修改函数；
3. ald_spi_reset()函数修改;
4. ald_dma_irq_handler()函数修改；
5. 更改ald_i2c_er_irq_handler() 检测到NACK的处理逻辑；
6. 的Application中，GUI工程文件中添加ald_rmu.c文件；
7. **md_utils.c文件中增加md_delay_us()函数；**
8. **md_timer.h文件中增加SMCON寄存器的BIT3和BIT15操作接口。**



### ES32F065x/ES32F033x

1. ald_spi_reset()函数修改;
2. ald_dma_irq_handler()函数修改。



### Book1 Example

1. 更新dma相关的例程，使程序可以循环运行；
2. 修改了原来的SPI_Enhance/ald/06_i2s例程，增加了录音功能；
2. **ADC模块例程中，增加使用DMA乒乓模式搬运ADC转换结果的例程；**
4. **ADC模块例程中，增加 1次标准转换后自动3次插入转换的例程；**
5. **Timer模块例程中，增加 ET信号清除比较输出的例程。**



### Book2 Example

1. 修改所有Bootloader例程，APP地址改为0x1000；
2. 更新fatfs中间件，逻辑卷不再关联硬件驱动，只记录其所在的物理驱动索引，减少耦合性；
3. 更新fatfs中间件，ff_gen_drv.h减少抽象层暴露的接口，ff_gen_drv.c增加多分区情况下的参数检查，增加系统中物理驱动和逻辑卷数量查看功能；
4. 更新已有的4个fatfs例程，01_FatFs_NANDFlash，02_FatFs_SRAM，03_FatFs_uSD，04_FatFs_spi_flash；
5. 新增音频例程，可以从SD卡播放音频，或录音存放到SD卡。



--------------------------------------------------------------------------------------------------------



## V1.14 2021-12-20

### ES32F36xx/ES32F33xx：

1. ES32F36xx的ALD例程中，QSPI增加DAC模式下的Quad通信例程。
2. 修订CRC的ALD/MD驱动程序中， ald_crc_init初始化函数中的移位错误。
3. 修订IIC的ALD驱动程序中，ald_i2c_reset函数的置位错误。
4. WDT的ALD的喂狗函数中，喂狗后增加延时。
5. ALD/MD的utils驱动中，sys_cfg函数中读取0x803D0寄存器。
6. 第三方Third_Party文件中增加FreeRTOS V10.4.2版本源码。
7. ES32F36xx的Applications中，增加FreeRTOSV10.4.2的相关例程。
8. ald_i2c.c文件修改I2C_STAT_BUSY标志等待时间 10S->10ms。
9. ald_i2c.c文件eeprom写函数（轮询、中断、DMA）区分ADDR与DATA字节数NBYTE设定值。
10. ald_i2c.c文件i2c_req_mem_write()函数添加地址发送完成检测功能（TCR标志）。
11. app_update.c 添加application_check_and_run()函数APP程序栈地址初始化功能。
12. es_hid_lab.c 添加ok_ack()以及err_ack()函数帧校验功能。
13. es_hid_lab.c es_lab_commands_process()函数flash操作前关闭地址映射功能。
14. md_i2c.c源文件：修改函数_i2c_speed_init()，使实际频率误差更小。
15. boot.c源文件：跳转之前将MSP修改为APP栈地址。
16. boot_fatfs.c源文件：跳转之前将MSP修改为APP栈地址。
17. ald_dma.c源文件：ald_dma_irq_handler()函数，清标志放在回调函数后进行。
18. ald_i2c.c源文件：
 - ald_i2c_reset()函数，添加FIFO清除操作；
 - 源文件中while(FLAG)查询标志方式添加超时机制，避免死循环；
 - ald_i2c_mem_write_by_dma()函数修改Nbyte初始值，不包括address字节；
 - ald_i2c_mem_read_by_dma()函数修改Nbyte初始值，不包括address字节；
 - 全局超时时间(10ms),使用宏表示。
19. ald_spic源文件：ald_spi_send_recv_by_it()函数，添加从机模式下，FIFO异常时spi复位。

### ES32F010x

1. 更新CMU MD库函数，以适应 ES32F0100 和 ES32F0101 不同的HRC最高频率。


### 其他

1. 新增 ES32H040x 、ES32F0283 系列产品。

2. 去除 ES32F0271、ES32F0500、ES32F0541 系列产品。

--------------------------------------------------------------------------------------------------------



## V1.13 2021-10-08

- 新增ES32F010x MD库函数及其例程。
- 新增 《ES32微控制器应用入门》配套例程Book1_Example。
- ES32F3修订：

  - 修订ES32F36xx的ald_qspi.h/ald_qspi.c文件中的冗余程序；
  - 修改ES32F36xx的QSPI例程中01_qspi_dac例子；
  - ES32F36xx的PIS例程中增加IO通过PIS触发ADC例子；
  - ES32F36xx的PIS例程中增加定时器计数IO，并触发定时器捕获例程；
  - 修订es32f3xxx.h文件中，MSC的FLASHADDR寄存器位域错误；
  - 修订ES32F0/F3 的ald_wdt.c文件中，ald_iwdt_clear_flag_status函数清中断标志位时未解锁错误；
  - 修订ES32F36x的DMA ping-pong例程中,单次传输完成后未使能通道bug;
  - ES32F36xx例程中，SPI 03_send_read_by_it例程中，NSS引脚默认初始化为高；
  - 修订ES32F36xx 的FLASH例程中main函数中读个数错误；
  - ES32F36xx的wwdt例程，使能LRC时钟；
  - ES32F36xx/ES32F336X 的adc中增加offset校准接口ald_adc_offset_adjust；
  - ES32F36xx的nand操作中，修订nand的page大小判断由65535改为65536；
  - ES32F3的MD库md_utils.c文件中增加adc_config函数；
  - ES32F3系列芯片的启动文件中增加ADC参数配置；
  - ES32F36xx/ES32F336x的utils.c文件中增加adc_config函数；
  - ES32F36xx的TIMER中增加pis出发两个ADC同时工作的例程；
  - 更新ES32F36xx的gcc启动文件。

--------------------------------------------------------------------------------------------------------




## V1.12 2021-05-27

### ES32F065x/ES32F033x:

1. ALD/MD库函数各.h和.c文件修改新文件说明；
2. TIMER0例程中增加encoder例程；
3. ald_adc.h文件中增加ald_adc_normal_get_value_calib、ald_adc_insert_get_value_calib、ald_adc_adjust_value接口函数；
4. ald_uart.c文件中修订ald_uart_irq_handler函数；
5. ald_timer.c文件中，ald_timer_pwm_set_duty函数修订；
6. ald_can.c文件中，ald_can_recv函数增加接收检查；
7. ald_uart.c文件中，ald_uart_irq_handler函数中，发送数据前清UART_IF_TXS标志；
8. MDK/IAR的.s启动文件中调用sys_config函数；
9. 增加IAP例程；

### ES32F36xx/ES32F33xx:

1. ALD/MD库函数各.h和.c文件修改新文件说明；
2. ald_dma.c文件中，dma中断先清标志再执行回调函数；
3. md_timer.c文件中，修订ic4_config函数中的错误；
4. md_adc.h文件中，修订SMPT相关的内联函数；
5. MD库中增加md_ecc的.h和.c文件；
6. TIMER0中增加encoder例程；
7. ald_uart.c文件中，修订ald_uart_recv_by_dma函数修订；
8. ald_timer.c文件中，ald_timer_pwm_set_duty函数修订；
9. ald_timer.c文件中，ald_timer_set_freq函数接口修改；
10. utils.c文件中增加sys_config函数；
11. ald_can.c文件中，ald_can_recv函数中，增减接收检查；
12. MDK/IAR的.s启动文件中调用sys_config函数；
13. ald_tick_init函数中systick中断优先级配置错误修订；
14. usbd_comp.c文件中，comp_interface_change和comp_ep_change函数形参变量名；

--------------------------------------------------------------------------------------------------------



## V1.11 2021-03-15

### ES32F065x/ES32F033x:

1. ALD/MD库函数中，GPIO的写改为BSSR寄存器操作；
2. ALD库函数中，中断方式发送数据前，清TXS标志位；
3. ALD库函数中，增加ADC软件校准功能。

### ES32F36xx/ES32F33xx:

1. ALD/MD库函数中，GPIO的写改为BSSR寄存器操作；
2. ALD/MD库函数中，ADC初始化时，使能ADC校准功能。


### ES32F065x:

1.	ES32F065x的ald库函数，ald_uart.c文件中，中断接收增加了容错机制；
2.	ES32F065x的ald库函数，ald_adc.c文件ald_adc_timer_trigger_insert函数修订；
3.	ES32F065x中增加SDCard通信例程，且移植了fatfs文件系统；
4.	ES32F065x的ald_uart_recv状态标志位判断错误修订；
5.	ES32F065x的uart_1k_xmode例程中，烧录位置改为末32k,启动位置为末8k位置;
6.	ES32F065x的库函数中增加GPIO的宏操作；
7.	ES32F065x的Templates_ALD工程中增加GCC的开发环境；
8.	ES32F065x系统启动后默认关闭LOSC;
9.	ES32F065x的头文件包含关系修订；
10.	中间层boot_flash.h文件中宏定义修改。

### ES32F36xx:

1. ES32F3xxx的库函数中增加GPIO的宏操作；

2. ES32F3xxx的Templates_ALD工程中增加GCC的开发环境；

3. ES32F3xxx系统启动后默认关闭LOSC;

4. ES32F3xxx的uart_1k_xmode/usb_host_fatfs、usb_dev_fatfs/dev_hid_boot四个例子中，烧录位置末尾32k,启动位置为末8k处；

5. ES32F3xxx的QSPI例程中增加QPI例程；

6. ES32F3xxx.h文件中，MSC_FLASHADDR寄存器的IFREN bit18改为bit19；

7. ES32F3xxx的ADC0/ADC1共同操作ADC0的CCR寄存器（共用一个参考）；

8. ES32F3xxx的md库函数，md_uart_set_abrmod函数修订；

9. ES32F3xxx的md库函数，md_uart_clear_flag_abend函数修订；

10. ES32F3xxx的ald库函数，ald_qspi.c文件中QSPI_CR_IDLES修改为QSPI_CR_IDLED_MSK;

11. ES32F3xxx的ald库函数，ald_can.c文件中can_clear_flag函数修改为ald_can_clear_flag_status；

12. ES32F3xxx的adc_init_t结构体中增加adc_ich_nr_t ich_nr;

13. ES32F3xxx的adc_timer_config_结构体中增加adc_ich_config_t i_config;

14. ES32F3xxx的ald库函数，增加ald_adc_timer_trigger_insert(adc_timer_config_t *config)接口；

15. ES32F3xxx的ald库函数，增加ald_adc_timer_trigger_insert(adc_timer_config_t *config)接口；

16. ES32F3xxx的ald库函数，写IIC的TXDATA寄存器前，等待FIFO非满再写；

17. ES32F3xxx的ald库函数，写SPI的DATA寄存器前，等待FIFO非满再写；

18. ES32F3xxx的ald库函数，写UART的TXBUF前，等待FIFO非满再写；

19. ES32F3xxx的md库函数，增加md_uart_clear_flag_abto(UART_TypeDef * UARTx)；

20. ES32F3xxx的ald库函数，ald_spi.c文件写DATA寄存器前，由判断TXE改为TXF；

21. ES32F3xxx的启动文件中增加配置字写过程；

22. ES32F3xxx的头文件包含关系修订；

23. ES32F3的ald_adc.c和md_adc.c文件中，对CCR寄存器操作作修订；

--------------------------------------------------------------------------------------------------------



## V1.10 2021-02-07

### ES32F065x:

1.	ES32F065x的ald库函数，ald_uart.c文件中，中断接收增加了容错机制；
2.	ES32F065x的ald库函数，ald_adc.c文件ald_adc_timer_trigger_insert函数修订；
3.	ES32F065x中增加SDCard通信例程，且移植了fatfs文件系统；
4.	ES32F065x的ald_uart_recv状态标志位判断错误修订；
5.	ES32F065x的uart_1k_xmode例程中，烧录位置改为末32k,启动位置为末8k位置;
6.	ES32F065x的库函数中增加GPIO的宏操作；
7.	ES32F065x的Templates_ALD工程中增加GCC的开发环境；
8.	ES32F065x系统启动后默认关闭LOSC;
9.	ES32F065x的头文件包含关系修订；
10.	中间层boot_flash.h文件中宏定义修改。

### ES32F36xx:

1.	ES32F3xxx的库函数中增加GPIO的宏操作；
2.	ES32F3xxx的Templates_ALD工程中增加GCC的开发环境；
3.	ES32F3xxx系统启动后默认关闭LOSC;
4.	ES32F3xxx的uart_1k_xmode/usb_host_fatfs、usb_dev_fatfs/dev_hid_boot四个例子中，烧录位置末尾32k,启动位置为末8k处；
5.	ES32F3xxx的QSPI例程中增加QPI例程；
6.	ES32F3xxx.h文件中，MSC_FLASHADDR寄存器的IFREN bit18改为bit19；
7.	ES32F3xxx的ADC0/ADC1共同操作ADC0的CCR寄存器（共用一个参考）；
8.	ES32F3xxx的md库函数，md_uart_set_abrmod函数修订；
9.	ES32F3xxx的md库函数，md_uart_clear_flag_abend函数修订；
10.	ES32F3xxx的ald库函数，ald_qspi.c文件中QSPI_CR_IDLES修改为QSPI_CR_IDLED_MSK;
11.	ES32F3xxx的ald库函数，ald_can.c文件中can_clear_flag函数修改为ald_can_clear_flag_status；
12.	ES32F3xxx的adc_init_t结构体中增加adc_ich_nr_t ich_nr;
13.	ES32F3xxx的adc_timer_config_结构体中增加adc_ich_config_t i_config;
14.	ES32F3xxx的ald库函数，增加ald_adc_timer_trigger_insert(adc_timer_config_t *config)接口；
15.	ES32F3xxx的ald库函数，增加ald_adc_timer_trigger_insert(adc_timer_config_t *config)接口；
16.	ES32F3xxx的ald库函数，写IIC的TXDATA寄存器前，等待FIFO非满再写；
17.	ES32F3xxx的ald库函数，写SPI的DATA寄存器前，等待FIFO非满再写；
18.	ES32F3xxx的ald库函数，写UART的TXBUF前，等待FIFO非满再写；
19.	ES32F3xxx的md库函数，增加md_uart_clear_flag_abto(UART_TypeDef * UARTx)；
20.	ES32F3xxx的ald库函数，ald_spi.c文件写DATA寄存器前，由判断TXE改为TXF；
21.	ES32F3xxx的启动文件中增加配置字写过程；
22.	ES32F3xxx的头文件包含关系修订；
23.	ES32F3的ald_adc.c和md_adc.c文件中，对CCR寄存器操作作修订。

## V1.09 2020-11-26

### ES32F065x:

1. 修正MD库中READ_BIT操作；
2. 增加ES32F065x MD例程；
3. ald_uart.c文件中，中断接收增加了容错机制；
4. MD&ALD增加GPIO的宏操作。


### ES32F36xx:

1. 修正MD库中READ_BIT操作；
2. 修正ALD库中通信外设FIFO操作；
3. 删除CLAC模块中除法操作；
4. 增加USB协议栈从机代码注释(主机注释后续添加)；
5. UART模块ALD例程中增加软件模拟7816例程；
6. adc_init_t结构体中增加adc_ich_nr_t ich_nr；
7. adc_timer_config_结构体中增加adc_ich_config_t i_config；
8. 增加ald_adc_timer_trigger_insert(adc_timer_config_t *config)接口；
9. 增加ald_adc_timer_trigger_insert(adc_timer_config_t *config)函数的实现；
10. 写IIC的TXDATA寄存器前，等待FIFO非满再写；
11. 写SPI的DATA寄存器前，等待FIFO非满再写；
12. 写UART的TXBUF前，等待FIFO非满再写；
13. 增加md_uart_clear_flag_abto(UART_TypeDef * UARTx)。
14. md_uart_set_abrmod函数修改；
15. md_uart_clear_flag_abend函数修改；
16. ald_qspi.c文件中QSPI_CR_IDLES修改QSPI_CR_IDLED_MSK；
17. ald_can.c文件中can_clear_flag函数修改为ald_can_clear_flag_status；
18. MD&ALD增加GPIO的宏操作。


### ES32F0271:

1. uart增加parity判断、ADC校正流程优化、MCM例程编译错误修正

### ES32F0541:

1. uart增加parity判断、ADC校正流程优化、MCM例程编译错误修正

### ES32F0930：

1. uart增加parity判断、ADC校正流程优化、MCM例程编译错误修正



## V1.08 2020-10-16

### ES32F065x:

1. CMU模块：

   1.1 增加API，获取时钟安全管理当前使用的时钟源(内部时钟/外部时钟)

2. ADC模块：

   2.1 增加timer触发ADC插入组转换例程

   2.2 增加timer_pis_adc_dma例程

3. PMU模块：

   3.1 增加md_pmu.c文件

4. RMU模块：

   4.1 增加md_rmu.c文件

5. TIMER模块：

   5.1 修改DMA有关的API接口参数

6. UART模块：

   6.1 优化UART模块中FIFO相关函数接口

7. USART模块：

   7.1 删除USART初始化结构体usart_init_t无效成员变量over_sampling

   7.2 修正接口函数md_usart_set_smartcard_psc()中的BUG

8. DMA模块：

   8.1 增加ald_dma_descriptor_cplt_get()接口，获取乒乓模式下，当前传输完成的描述符

   8.2 优化ald_dma_config_sg_per()接口

9. I2C模块：

   9.1 优化md_i2c_addr_t结构体

10. RTC模块：

      10.1 删除库函数中写SSEC寄存操作

11. CAN模块：

       11.1 修正库函数中的一个BUG，该BUG会导致极端情况下错误帧的误接收

12. Utility：

       12.1 增加获取UID/CHIPID接口函数

       12.2 使库函数符合C-STAT(STDCHECKS)规范


### ES32F033x：

1. CMU模块：

   1.1 增加API，获取时钟安全管理当前使用的时钟源(内部时钟/外部时钟)

2. ADC模块：

   2.1 增加timer触发ADC插入组转换例程
   2.2 增加timer_pis_adc_dma例程

3. PMU模块：

   3.1 增加md_pmu.c文件

4. RMU模块：

   4.1 增加md_rmu.c文件

5. TIMER模块：

   5.1 修改DMA有关的API接口参数

6. UART模块：

   6.1 优化UART模块中FIFO相关函数接口

7. USART模块：

   7.1 删除USART初始化结构体usart_init_t无效成员变量over_sampling
   7.2 修正接口函数md_usart_set_smartcard_psc()中的BUG

8. DMA模块：

   8.1 增加ald_dma_descriptor_cplt_get()接口，获取乒乓模式下，当前传输完成的描述符
   8.2 优化ald_dma_config_sg_per()接口

9. I2C模块：

   9.1 优化md_i2c_addr_t结构体

10. RTC模块：

    10.1 删除库函数中写SSEC寄存操作

11. Utility：

     11.1 增加获取UID/CHIPID接口函数
     11.2 使库函数符合C-STAT(STDCHECKS)规范

### ES32F36xx：

1. CMU模块：

   1.1 增加API，获取时钟安全管理当前使用的时钟源(内部时钟/外部时钟)
   1.2 增加设置/读取HCLK2总线分频函数接口
   1.3 优化md_cmu_clock_config()/ald_cmu_clock_config()接口
   1.4 全速USB模式，支持HRC作为USB模块时钟

2. ADC模块：

   2.1 增加timer触发ADC插入组转换例程
   2.2 在MD库中增加ETS,IETS位操作函数
   2.3 增加timer_pis_adc_dma例程
   2.4 修改不连续扫描模式控制逻辑

3. PMU模块：

   3.1 增加md_pmu.c文件
   3.2 ALD库中增加LDO12/LDO18配置接口

4. RMU模块：

   4.1 增加md_rmu.c文件

5. BKPC模块：

   5.1 增加md_bkpc.c文件

6. USB模块：

   6.1 增加virtual_serial_port例程，可直接作为USB转TTL工具

7. TIMER模块：

   7.1 增加timer_dma_input_capture例程，使用DMA传输的输入捕获例程
   7.2 增加timer_input_capture_two_channel例程，双通道输入捕获例程
   7.3 修改DMA有关的API接口参数

8. DAC模块：

   8.1 增加dac_dma_two_channel_sine例程，双通道正弦波例程

9. UART模块：

   9.1 优化UART模块中FIFO相关函数接口

10. DMA模块：

      10.1 增加ald_dma_descriptor_cplt_get()接口，获取乒乓模式下，当前传输完成的描述符
      10.2 优化ald_dma_config_sg_per()接口

11. RTC模块：

       11.1 删除库函数中写SSEC寄存操作

12. CAN模块：

       12.1 修正库函数中的一个BUG，该BUG会导致极端情况下错误帧的误接收

13. I2C模块：

       13.1 优化md_i2c_init()接口函数

14. I2S模块：

       14.1 优化I2S库函数
       14.2 增加I2S例程

15. Bootloader：

       15.1 简化USB模式Bootloader升级方式，MDK/IAR生成的bin文件可以直接拖拽升级

16. Discovery开发板：

       16.1 增加Discovery开发板BSP、例程

17. Utility：

       17.1 增加获取UID/CHIPID接口函数
       17.2 使库函数符合C-STAT(STDCHECKS)规范

### ES32F0271:

1. DAC模块：

   1.1.md_dac.h: 修正寄存器缺少部分

2. EXTI模块：

   2.1.md_exti.h: 修正function设置錯誤

3. UART模塊：

   3.1.md_uart.h: 修正寄存器错误

4. ADC模塊：

   4.1.md_adc.h: 修正function名称

   4.2.ald_adc.c: 修改变量为static变量 / 多余printf拿掉 / 删除没用到变数

   4.3.md_adc.c: 修改变量为static变量 / 多余printf拿掉 / 删除没用到变数

   4.4.ALD例程:ADC_Calibration_From_Flash，刪除沒用到变量

   4.5.MD例程:ADC_Calibration_From_Flash，刪除沒用到变量

5. USB模块：

   5.1.md_usb.c:修正CDC錯誤

   5.2.例程:usbdev_cdc_serial，修正CDC错误

6. GPIO模块：

   6.1.md_gpio.h: 增加GPIOx->IDATA每个bit读取方式

### ES32F0541:

1. DAC模块：

   1.1.md_dac.h: 修正寄存器缺少部分

2. EXTI模块：

   2.1.md_exti.h: 修正function设置錯誤

3. UART模块：

   3.1.md_uart.h: 修正寄存器错误

4. ADC模块：

   4.1.md_adc.h: 修正function名称

   4.2.ald_adc.c: 修改变量为static变量 / 多余printf拿掉 / 删除没用到变数

   4.3.md_adc.c: 修改变量为static变量 / 多余printf拿掉 / 删除没用到变数

   4.4.ALD例程:ADC_Calibration_From_Flash，刪除沒用到变量

   4.5.MD例程:ADC_Calibration_From_Flash，刪除沒用到变量

5. GPIO模块

   5.1.md_gpio.h: 增加GPIOx->IDATA每个bit读取方式



## V1.07 2020-5-11

### ES32F065x:

1. CAN模块

   删除can_filter_t结构体无效的成员变量bank_number[ALD]；
   增加CAN接收数据时FIFO1的支持[ALD]；

2. TRNG模块
   在ald_trng_init()函数中增加参数检验[ALD]；

3. DMA模块
   在DMA模块中增加"乒乓模式"、"分散-加载模式"的支持[ALD/DM/Project]；

4. PMU模块
   增加ald_pmu_standby_enter()接口函数[ALD]；

5. ADC模块
   修改ADC模块结构体变量名称，使其变得简洁，并且能望文知意[ALD/MD/Project]；

6. CRC模块
   在md_crc_init_t结构体中增加一些成员变量[MD]；

7. MSC
   增加FLASH读取等待时间设置的API函数[MD]；

8. 中间件Bootloader
   增加对"XMODE"通信协议的支持，通过编译宏"XMODE_1K/XMODE_128"可分别选择"1K-XMODE/XMODE"通信协议；

9. 优化例程
   优化TIMER/MSC/ADC/CAN/TRNG/RTC模块例程。

10. IAR工程文件
    优化所有IAR工程文件。

### ES32F033x

1. TRNG模块
   在ald_trng_init()函数中增加参数检验[ALD]；
2. DMA模块
   在DMA模块中增加"乒乓模式"、"分散-加载模式"的支持[ALD/DM/Project]；
3. PMU模块
   增加ald_pmu_standby_enter()接口函数[ALD]；
4. ADC模块
   修改ADC模块结构体变量名称，使其变得简洁，并且能望文知意[ALD/MD/Project]；
5. CRC模块
   在md_crc_init_t结构体中增加一些成员变量[MD]；
6. MSC
   增加FLASH读取等待时间设置的API函数[MD]；
7. 中间件Bootloader
   增加对"XMODE"通信协议的支持，通过编译宏"XMODE_1K/XMODE_128"可分别选择"1K-XMODE/XMODE"通信协议；
8. 优化例程
   优化TIMER/MSC/ADC/CAN/TRNG/RTC模块例程。
9. IAR工程文件
   优化所有IAR工程文件。

### ES32F36xx

1. CAN模块
   删除can_filter_t结构体无效的成员变量bank_number[ALD]；
   增加CAN接收数据时FIFO1的支持[ALD]；

2. TRNG模块
   在ald_trng_init()函数中增加参数检验[ALD]；
3. DMA模块
   在DMA模块中增加"乒乓模式"、"分散-加载模式"的支持[ALD/DM/Project]；
4. PMU模块
   增加ald_pmu_standby_enter()接口函数[ALD]；
5. ADC模块
   修改ADC模块结构体变量名称，使其变得简洁，并且能望文知意[ALD/MD/Project]；
6. CRC模块
   在md_crc_init_t结构体中增加一些成员变量[MD]；
7. MSC模块
   增加FLASH读取等待时间设置的API函数[MD]；
8. PIS模块
   在PIS消费端增加对ADC1的支持[ALD/MD]；
9. CMU模块
   增加get_hclk2_clock()函数接口[ALD/MD]；
10. 中间件Bootloader
    增加对"XMODE"通信协议的支持，通过编译宏"XMODE_1K/XMODE_128"可分别选择"1K-XMODE/XMODE"通信协议；
11. 修正错误
    修改md_cmu.h/md_rmu.h/md_pmu.h文件中存在的一些错误；
12. 优化例程
    优化MSC/ADC/CAN/TRNG/RTC/Dhrystone模块例程。

### 附录：

本次更新，ADC模块对上层应用会有影响，应用层对ADC模块初始化时使用的变量名需要进行更改。
其余模块对上层应用基本上无影响。
ADC模块结构体变量名更改细节如下[涉及芯片系列：ES32F065x/es32f033x/ES32F36xx]：

1. adc_init_t结构体：
   adc_align_t data_align;	          ---> adc_align_t align;	
   type_func_t scan_mode;        ---> type_func_t scan;       
   type_func_t cont_mode;        ---> type_func_t cont;       
   adc_nch_len_t nch_len;          ---> adc_nch_nr_t nch_nr;  	
   adc_disc_mode_t disc_mode; ---> adc_disc_mode_t disc;   
   adc_disc_nbr_t disc_nbr;        ---> adc_disc_nr_t disc_nr;	
   adc_conv_res_t conv_res;      ---> adc_conv_bit_t data_bit;
   adc_clk_div_t clk_div;	          ---> adc_clk_div_t div;	
   adc_nchesel_t nche_sel;	       ---> adc_nchesel_t nche_sel;	
   adc_neg_ref_t neg_ref;         ---> adc_neg_ref_t n_ref;    
   adc_pos_ref_t pos_ref;          ---> adc_pos_ref_t p_ref;   

2. adc_nch_conf_t结构体：
   adc_channel_t channel;    ---> adc_channel_t ch;	
   adc_nch_rank_t rank;       ---> adc_nch_idx_t idx;	
   adc_samp_t samp_time;   ---> adc_samp_t samp;	

3. adc_ich_conf_t结构体：
   adc_channel_t channel;     ---> adc_channel_t ch;
   adc_ich_rank_t rank;         ---> adc_ich_idx_t idx;
   adc_samp_t samp_time;    ---> adc_samp_t samp;
   uint32_t offset;                ---> uint32_t offset;
   adc_ich_len_t ich_len;       ---> adc_ich_nr_t nr;
   type_func_t auto_inj;        ---> type_func_t auto_m;

4. adc_handle_t结构体：
   adc_reg_cplt_cbk          ---> normal_cplt_cbk
   adc_inj_cplt_cbk           ---> insert_cplt_cbk
   adc_out_of_win_cbk     ---> wdg_cbk
   adc_error_cbk              ---> error_cbk
   adc_ovr_cbk                ---> ovr_cbk



## V1.06a 2020-5-8

1. CAN模块ALD库及例程升级[ES32F36xx/ES32F065x/ES32F033x]
2. DMA模块ALD库、MD库、例程升级[ES32F36xx/ES32F065x/ES32F033x]
3. TRNG模块ALD库及例程例程升级[ES32F36xx/ES32F065x/ES32F033x]
4. I2C模块ALD库升级[ES32F065x/ES32F033x]
5. CMU模块ALD库、MD库升级[ES32F36xx]
6. PIS模块MD库及例程升级[ES32F36xx]
7. PMU模块ALD库、例程升级[ES32F065x/ES32F033x]
8. 修改ES32F0271 md_usb.c的清除中断标志的方式，解决误清中断的问题。



## V1.06 2020-4-28

1. ES32F36xx初版发布
2. ES32F0541初版发布
3. ES32F0500初版发布



## V1.05a 2019-12-30

1. ES32F0271 MD修订：

   - md_uart.h: 修正function定义字使用错误，UART_FCON_TXFL_POSS改为UART_FCON_RXFL_POSS

     __STATIC_INLINE uint32_t md_uart_get_fcon_rxfl(UART_TypeDef *UARTx) { return ((READ_BIT(UARTx->FCON, UART_FCON_RXFL_MSK))>>UART_FCON_RXFL_POSS); }

2. USB lib修订

   - 增加Composite serial driver



## V1.05 2019-12-24

1. ES32F0271ALD修订：

   - ald_adc.c : 判断所要量测的条件如果不符合，即舍弃校正，使用直接测量到的adc值

   - ald_crc.c: 删除测试代码 (extern __IO uint32_t DMA_INTR)

2. ES32F0271 MD修订：

   - md_adc.c : 判断量测的条件，如果不符合，即舍弃校正，使用直接量测到的adc值
   - md_uart.c: 修正程式小问题，function中有使用到UART1参数部分修改为UARTx，可根据User需求使用UART1与UART2

3. ES32F0271 例程修订：
   - update Sconscript: 自动构建project
   - Re-update project: 重新编译MD/ALD project支持Keil及IAR工程



## V1.04 2019-11-13

1. ES32F0271例程修订：
   - 修改部分USB 例程描述符信息。
   - 修改usbdev audio例程,增加使用外部24.576MHz晶振作为IIS时钟，改善播放效果。
   - 修改usb_hid_bootloader和usb_hid_userspec例程，统一这两个例程中的usbhid_custom.c函数接口。
   - 将usb_hid_bootloader例程重命名为usb_hid_custom_boot。
   - 将usb_hid_userspec例程重命名为usb_hid_custom_userspec。
   - 补充ALD例程。



## V1.03 2019-10-9

1. Drivers\CMSIS\Device\EastSoft\ES32F0271\Startup\iar\ : 增加startup_es32f027x.s
2. ES32F0271 ADC MD增加ADC校准函数
3. ES32F0271例程修订：

   - 增加MD ADC校准例程
   - 增加MD各例程支持IAR工程
   - 增加ALD各例程支持IAR工程
   - 增加USB例程
4. ES32F033x和ES32F065x 增加CMU的ALD例程



## V1.02 2019-7-9

1. ES32F0271支持ALD驱动库及其例程.

2. ES32F0271USB例程修订：

   - 修改usbdev bulk例程，使其支持winusb驱动。
   - 修改usbdev hid userspec例程，使其能在上位机演示。
   - 增加usbdev msc bootloader例程。
   - 增加usbdev hid bootloader例程。
   - 增加usbhost msc bootloader例程。

3. USB Library 修订：

   - 修改usbdbulk.c，支持winusb驱动.

   - 修改usbhmsc.c，支持没有DMA的ES32F0271芯片.
   - 修改usbhscsi.c，调用部分函数会进入Hardfault.
   - 修改USB的DMA传输接口.



## V1.01 2019-3-22

1. 支持ES32F033x Device/MD/ALD/Projects.
2. ES32F065x IAR例程适配到8.11.1版本.
3. USB Library 增加主机驱动，修改了USB的DMA传输接口以及所有的函数名称.



## V1.00 2019-1-4

初版发布

1. 支持ES32F0271 Device/MD/Projects.
2. 支持ES32F065x Device/MD/ALD/Projects.
3. 支持 ES32 USB Library.













