# ES32_SDK

#### 介绍

ES32 SDK 是东软载波微电子开发的、面向ES32系列微控制器内核以及外设的一套高集成、易使用、面向过程与对象相结合的驱动库，包括 MD、ALD、BSP、中间层驱动。SDK兼容CMSIS标准，可以高效地移植不同的操作系统、文件系统等第三方软件。 SDK集成了多方中间层软件，中间层软件对整个ES32系列微控制器保持兼容，能够做到不同平台之间的简单移植。

MD驱动面向过程开发，接近微控制器底层操作，提供用户微控制器寄存器操作简单接口，操作方便，同时MD驱动提供内联以及非内联调用函数的方式，最大化用户代 码执行效率。

ALD 驱动对微控制器外设做抽象化操作，是一套抽象化的面向对象的驱动，用 户无需更多关注底层设备的原理，只需要调用相关外设的接口函数即可对外设进行操作， ALD 驱动同时能够为上层应用以及操作系统、文件系统等应用和系统层软件提供接口，提高移植的兼容性。 

BSP 驱动提供了基于 ES32 微控制器开发板 ES-PDS 的驱动，方便用户进行板级 开发。

此外为了更加方便用户使用 SDK 开发项目， ES-LINK2、 USB-Lab、 ES-Bridge、 SCONS 自动构建工具、 ES-PDS 等软件、硬件工具都已经推出。 使用 ES32 SDK 开发应用程序可以 大大缩减开发时间，降低开发难度，降低项目开发的开销。    

#### 软件架构

SDK 目录下有 Drivers、Middlewares、Projects、tools、Utilities 五个文件目录， Drivers目录下放置的是 MD、 ALD、 BSP、 CMSIS 驱动代码文件以及说明文档，Middlewares目录下放置的是中间层代码文件以及说明文档，例如USB驱动库文件，Projects目录下放置的是各微控制器芯片的例程，Utilities目录下放置的是包括USB例程配套的USB PC端驱动等其它软件工具， tools文件下放置的是自动构建工具使用的文件，用户无需关心。

#### 使用说明

ES32 SDK 目前支持 MDK、 IAR、 iDesigner 等平台。    