/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Apr 2021
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Apr 2021     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */

#include "main.h"
#include <stdlib.h>


/** @addtogroup Projects_Templates_ALD
  * @{
  */

/** @addtogroup Templates
  * @{
  */
uint32_t tick0;
uint32_t tick1;
uint32_t time;

/**
  * @brief  This is main function.
  *         Detect running time.
  * @retval Status
  */
int main()
{
    uint32_t i;
    uint8_t com;

    /* Initialize ALD */
    ald_cmu_init();
    /* Get first tick */
    tick0 = ald_mcu_get_tick();

    /* do something */
    for (i = 0; i < 0xff; ++i)
    {
        com = 1;
        com = i + com + 3;
        com = com + 24;
    }

    /* Get second tick */
    tick1 = ald_mcu_get_tick();
    /* time = (tick1 -tick0) * 1 / flck */
    time  = tick1 - tick0;

    while (1)
    {
        ald_delay_ms(1000);
    }
}

/**
  * @}
  */
/**
  * @}
  */
