/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Apr 2021
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Apr 2021     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */
/** @addtogroup Examples
  * @{
  */
uint32_t cnt = 0;
/**
  * @brief  Initialize LED.
  * @param  None
  * @retval None
  */
void led_init(void)
{
    md_gpio_init_t x;

    /* Initialize sck pin */
    x.mode  = MD_GPIO_MODE_OUTPUT;
    x.odos  = MD_GPIO_PUSH_PULL;
    x.pupd  = MD_GPIO_PUSH_UP;
    x.podrv = MD_GPIO_OUT_DRIVE_6;
    x.nodrv = MD_GPIO_OUT_DRIVE_6;
    x.flt   = MD_GPIO_FILTER_DISABLE;
    x.type  = MD_GPIO_TYPE_TTL;
    x.func  = MD_GPIO_FUNC_1;
    md_gpio_init(LED_GPIO_PORT, LED_GPIO_PIN, &x);
}

/**
  * @brief  Initialize TIMER.
  * @param  timer: Pointer to the TIMER
  * @retval None
  */
void timer_base_init(TIMER_TypeDef *timer)
{
    md_timer_base_init_t init;

    md_timer_base_struct_init(&init);
    init.prescaler = 64;
    md_timer_base_set_config(timer, &init);
    md_timer_enable_uit_interrupt(timer);
    md_timer_enable_counter_cnten(timer);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    /* Configure system clock */
    md_cmu_pll_config(MD_CMU_PLL_INPUT_HRC_6, MD_CMU_PLL_OUTPUT_48M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL, 48000000);
    /* Initialize 1ms tick */
    md_init_1ms_tick();
    /* Enable all peripherals clock */
    md_cmu_perh_clock_config(MD_CMU_PERH_ALL, ENABLE);
    /* Enable BS16T0 interrupt */
    md_mcu_irq_config(BS16T0_IRQn, 2, ENABLE);

    /* Initialize LED */
    led_init();
    /* Initialize timer */
    timer_base_init(BS16T0);

    while (1)
    {
        md_delay_1ms(1000);;
    }
}

/**
  * @}
  */
/**
  * @}
  */

