/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Apr 2021
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Apr 2021     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */

#include "main.h"

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
uint8_t flag = 0;
md_rtc_time_t rtc_time;
md_rtc_date_t rtc_date;

/**
  * @brief  Initialize pin
  * @retval None
  */
void pin_init(void)
{
    md_gpio_init_t x;

    /* Initialize PA0_WKUP-TAMPER1_RTC #0 pin */
    x.mode  = MD_GPIO_MODE_INPUT;
    x.odos  = MD_GPIO_PUSH_PULL;
    x.pupd  = MD_GPIO_PUSH_UP;
    x.podrv = MD_GPIO_OUT_DRIVE_6;
    x.nodrv = MD_GPIO_OUT_DRIVE_6;
    x.flt   = MD_GPIO_FILTER_DISABLE;
    x.type  = MD_GPIO_TYPE_TTL;
    x.func  = MD_GPIO_FUNC_1;
    md_gpio_init(RTC_WKUP_PORT, RTC_WKUP_PIN, &x);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    md_rtc_init_t rtc_init;

    /* Initialize SysTick */
    md_init_1ms_tick();
    /* Enable all peripherals clock */
    md_cmu_perh_clock_config(MD_CMU_PERH_ALL, ENABLE);
    /* Select RTC clock source */
    md_rtc_source_select(MD_RTC_SOURCE_LOSM);
    /* Enable RTC interrupt */
    md_mcu_irq_config(RTC_IRQn, 3, ENABLE);

    pin_init();

    rtc_init.asynch_pre_div  = 0;
    rtc_init.synch_pre_div   = 32767;
    rtc_init.hour_format     = MD_RTC_HOUR_FORMAT_24;
    rtc_init.output          = MD_RTC_ALARMOUT_DISABLE;
    rtc_init.output_polarity = MD_RTC_OUTPUT_POLARITY_HIGH;
    md_rtc_init(&rtc_init);

    rtc_time.hour   = 21;
    rtc_time.minute = 22;
    rtc_time.second = 43;
    rtc_date.day    = 11;
    rtc_date.month  = 9;
    rtc_date.year   = 17;
    rtc_date.week   = 1;

    if ((md_rtc_set_time(&rtc_time, MD_RTC_FORMAT_DEC)) != MD_OK)
        return -1;

    if ((md_rtc_set_date(&rtc_date, MD_RTC_FORMAT_DEC)) != MD_OK)
        return -2;

    /* Clear time stamp interrupt flag */
    md_rtc_clear_flag_tc();
    /* Configure time stamp parameters */
    md_rtc_set_time_stamp(MD_RTC_TS_SIGNAL_SEL_TAMPER1, MD_RTC_TS_RISING_EDGE);
    /* Enable time stamp interrupt */
    md_rtc_enable_ts_intrrupt();

    while (1)
    {
        md_delay_1ms(1000);
    }
}

/**
  * @}
  */
/**
  * @}
  */

