/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Apr 2021
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Apr 2021     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */

#include "main.h"

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
md_rtc_time_t rtc_time;
md_rtc_date_t rtc_date;

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    md_rtc_init_t rtc_init;

    /* Initialize SysTick */
    md_init_1ms_tick();
    /* Enable all peripherals clock */
    md_cmu_perh_clock_config(MD_CMU_PERH_ALL, ENABLE);
    /* Select RTC clock source */
    md_rtc_source_select(MD_RTC_SOURCE_LOSM);

    rtc_init.asynch_pre_div   = 0;
    rtc_init.synch_pre_div    = 32767;
    rtc_init.hour_format      = MD_RTC_HOUR_FORMAT_24;
    rtc_init.output           = MD_RTC_ALARMOUT_DISABLE;
    rtc_init.output_polarity  = MD_RTC_OUTPUT_POLARITY_HIGH;
    md_rtc_init(&rtc_init);

    rtc_time.hour   = 23;
    rtc_time.minute = 59;
    rtc_time.second = 55;
    rtc_date.day    = 2;
    rtc_date.month  = 7;
    rtc_date.year   = 18;
    rtc_date.week   = 1;

    if ((md_rtc_set_time(&rtc_time, MD_RTC_FORMAT_DEC)) != MD_OK)
        return -1;

    if ((md_rtc_set_date(&rtc_date, MD_RTC_FORMAT_DEC)) != MD_OK)
        return -2;

    while (1)
    {
        md_delay_1ms(1000);
        md_rtc_get_time(&rtc_time, MD_RTC_FORMAT_BCD);
        md_rtc_get_date(&rtc_date, MD_RTC_FORMAT_BCD);
    }
}

/**
  * @}
  */
/**
  * @}
  */
