/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Apr 2021
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Apr 2021     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
timer_handle_t h_tim;
timer_clock_config_t clock;
timer_one_pulse_init_t init;

/**
  * @brief  Initializate pin of tim module.
  * @retval None
  */
void timer_pin_init(void)
{
    gpio_init_t x;

    /* Initialize tim0 ch1 pin */
    x.mode = GPIO_MODE_OUTPUT;
    x.odos = GPIO_PUSH_PULL;
    x.pupd = GPIO_PUSH_UP;
    x.flt  = GPIO_FILTER_DISABLE;
    x.type = GPIO_TYPE_TTL;
    x.nodrv = GPIO_OUT_DRIVE_6;
    x.podrv = GPIO_OUT_DRIVE_6;
    x.func = GPIO_FUNC_2;
    ald_gpio_init(TIMER0_PULSE_PORT, TIMER0_PULSE_PIN, &x);

    x.mode = GPIO_MODE_INPUT;
    x.pupd = GPIO_PUSH_DOWN;
    x.flt  = GPIO_FILTER_DISABLE;
    x.type = GPIO_TYPE_TTL;
    x.nodrv = GPIO_OUT_DRIVE_6;
    x.podrv = GPIO_OUT_DRIVE_6;
    x.func = GPIO_FUNC_2;
    ald_gpio_init(TIMER0_TRIGGER_PORT, TIMER0_TRIGGER_PIN, &x);
}


/**
  * @brief  Main function
  * @retval Status
  */
int main()
{
    /* Initialize ALD */
    ald_cmu_init();
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);
    /* Initialize pin and set default state */
    timer_pin_init();

    /* Initialize GP16C4T0 */
    h_tim.perh           = GP16C4T0;
    h_tim.init.prescaler = 0;
    h_tim.init.mode      = TIMER_CNT_MODE_UP;
    h_tim.init.period    = 65535;
    h_tim.init.clk_div   = TIMER_CLOCK_DIV1;
    h_tim.init.re_cnt    = 0;
    ald_timer_one_pulse_init(&h_tim, TIMER_OP_MODE_REPEAT);

    /* Initialize clock source */
    clock.source = TIMER_SRC_INTER;
    ald_timer_config_clock_source(&h_tim, &clock);

    /* Config one pulse channel */
    init.mode        = TIMER_OC_MODE_PWM2;
    init.pulse       = 16383;
    init.oc_polarity = TIMER_OC_POLARITY_HIGH;
    init.polarity    = TIMER_IC_POLARITY_RISE;
    init.sel         = TIMER_IC_SEL_DIRECT;
    init.filter      = 0;
    ald_timer_one_pulse_config_channel(&h_tim, &init, TIMER_CHANNEL_1, TIMER_CHANNEL_2);

    /* start one pulse */
    ald_timer_one_pulse_start(&h_tim, TIMER_OP_OUTPUT_CHANNEL_1);

    /* Stop one pulse */
    while (1)
    {
        ald_delay_ms(1000);
    }
}
/**
  * @}
  */
/**
  * @}
  */
