/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0.1
  * @date    28 Apr 2022
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Apr 2021     AE Team         The first version
  *          28 Apr 2022     AE Team         modify the system clock
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

uint32_t value[2] = {0};
uint32_t delay = 0;
timer_handle_t h_tim;
timer_clock_config_t tim_clock;

/**
  * @brief  Period elapse complete.
  * @param  arg: Pointer to tim_handle_t structure.
  * @retval None.
  */
void period_elapse_complete(timer_handle_t *arg)
{
    ald_timer_clear_flag_status(&h_tim, TIMER_FLAG_UPDATE);
    return;
}

/**
  * @brief  Delay elapse complete.
  * @param  arg: Pointer to tim_handle_t structure.
  * @retval None.
  */
void delay_elapse_complete(timer_handle_t *arg)
{
    return;
}

/**
  * @brief  Input capture complete.
  * @param  arg: Pointer to tim_handle_t structure.
  * @retval None.
  */
void capture_complete(timer_handle_t *arg)
{
    return;
}

/**
  * @brief  Pwm pulse complete.
  * @param  arg: Pointer to tim_handle_t structure.
  * @retval None.
  */
void pwm_pulse_complete(timer_handle_t *arg)
{
    return;
}

/**
  * @brief  Trigger complete.
  * @param  arg: Pointer to tim_handle_t structure.
  * @retval None.
  */
void trigger_complete(timer_handle_t *arg)
{
    return;
}

/**
  * @brief  Break complete.
  * @param  arg: Pointer to tim_handle_t structure.
  * @retval None.
  */
void break_complete(timer_handle_t *arg)
{
    return;
}

/**
  * @brief  Commutation complete.
  * @param  arg: Pointer to tim_handle_t structure.
  * @retval None.
  */
void commutation_complete(timer_handle_t *arg)
{
    return;
}

/**
  * @brief  Error complete.
  * @param  arg: Pointer to tim_handle_t structure.
  * @retval None.
  */
void error_complete(timer_handle_t *arg)
{
    return;
}

void timer_pin_init(void)
{
    gpio_init_t x;

    /* Initialize PA4 as output */
    x.mode = GPIO_MODE_OUTPUT;
    x.odos = GPIO_PUSH_PULL;
    x.flt  = GPIO_FILTER_DISABLE;
    x.type = GPIO_TYPE_TTL;
    x.nodrv = GPIO_OUT_DRIVE_6;
    x.podrv = GPIO_OUT_DRIVE_6;
    x.func = GPIO_FUNC_1;
    ald_gpio_init(TIM0_TOGGLE_PORT, TIM0_TOGGLE_PIN, &x);
}

void ald_timer_period_elapsed_callback(struct timer_handle_s *arg)
{
    ald_gpio_toggle_pin(TIM0_TOGGLE_PORT, TIM0_TOGGLE_PIN);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    /* Initialize ALD */
    ald_cmu_init();
    /* Configure system clock */
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
    ald_cmu_perh_clock_config(CMU_PERH_GPIO, ENABLE);
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

    /* Initialize pin */
    timer_pin_init();

    /* Initialize GP16C4T0 */
    h_tim.perh = GP16C4T0;
    h_tim.init.prescaler    = 0;
    h_tim.init.mode         = TIMER_CNT_MODE_UP;
    h_tim.init.period       = 999;
    h_tim.init.clk_div      = TIMER_CLOCK_DIV1;
    h_tim.init.re_cnt       = 0;
    h_tim.period_elapse_cbk = ald_timer_period_elapsed_callback;
    ald_timer_base_init(&h_tim);

    /* Initialize clock source */
    tim_clock.source = TIMER_SRC_INTER;
    ald_timer_config_clock_source(&h_tim, &tim_clock);

    /* Enable GP16C4T0 interrupt */
    ald_mcu_irq_config(GP16C4T0_LCD_IRQn, 1, ENABLE);
    /* Enable UPDATE interrupt */
    ald_timer_interrupt_config(&h_tim, TIMER_IT_UPDATE, ENABLE);
    /* Start input pwm from GP16C4T0 channel 1 */
    ald_timer_base_start(&h_tim);

    while (1)
    {
        ald_delay_ms(1000);
    }
}
/**
  * @}
  */
/**
  * @}
  */
