/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.1
  * @date    18 Oct 2023
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Apr 2021     AE Team         The first version
  *          18 Oct 2023     AE Team         Correct misconfiguration
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */

#include <string.h>
#include "main.h"
#include "ald_gpio.h"
#include "ald_lcd.h"
#include "ald_cmu.h"


/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

uint32_t tick0;
uint32_t tick1;
uint32_t time;
lcd_handle_t h_lcd;

void led_pin_init(void)
{
    gpio_init_t x;
    x.mode = GPIO_MODE_CLOSE;
    x.odos = GPIO_PUSH_PULL;
    x.pupd = GPIO_FLOATING;
    x.podrv = GPIO_OUT_DRIVE_20;
    x.nodrv = GPIO_OUT_DRIVE_20;
    x.flt  = GPIO_FILTER_DISABLE;
    x.type = GPIO_TYPE_TTL;
    x.func = GPIO_FUNC_0;
    ald_gpio_init(GPIOA, led_com_1 | led_com_2 | led_com_3 | led_seg_A | led_seg_B | led_seg_C | led_seg_D | led_seg_E| led_seg_F | led_seg_G, &x);

    x.mode = GPIO_MODE_CLOSE;
    x.odos = GPIO_PUSH_PULL;
    x.pupd = GPIO_FLOATING;
    x.podrv = GPIO_OUT_DRIVE_20;
    x.nodrv = GPIO_OUT_DRIVE_20;
    x.flt  = GPIO_FILTER_DISABLE;
    x.type = GPIO_TYPE_TTL;
    x.func = GPIO_FUNC_0;
    ald_gpio_init(GPIOB, led_com_4 | led_seg_H, &x);
}

void lcd_init(lcd_handle_t *h_lcd)
{
    led_pin_init();

    /* Initialize lcd */
    h_lcd->perh = LCD;
    h_lcd->init.lcd_bias   = LCD_BIAS_1_2;
    h_lcd->init.lcd_div    = LCD_DIV_16;
    h_lcd->init.lcd_duty   = LCD_DUTY_1_4;
    h_lcd->init.lcd_prs    = LCD_PRS_1;
    h_lcd->init.lcd_reshd  = LCD_RES_3MOHM;
    h_lcd->init.lcd_resld  = LCD_RES_3MOHM;
    h_lcd->init.lcd_vbufhd = LCD_FUNC_ENABLE;
    h_lcd->init.lcd_vbufld = LCD_FUNC_DISABLE;
    h_lcd->init.lcd_vchps  = LCD_VCHPS_3V2;
    h_lcd->init.lcd_vsel   = LCD_VSEL_VDD;
    h_lcd->init.lcd_wfs    = LCD_WAVE_A;
    h_lcd->init.lcd_vgs    = LCD_VGS_6;
    h_lcd->init.clock      = CMU_LCD_SEL_HRC_1M;
    ald_lcd_init(h_lcd);

    ald_lcd_write_seg(h_lcd, reg_seg_A | reg_seg_B | reg_seg_C | reg_seg_D | reg_seg_E | reg_seg_F | reg_seg_G | reg_seg_H);

    /* Enable lcd */
    ald_lcd_cmd(h_lcd, ENABLE);
    ald_lcd_led_init(h_lcd, ENABLE);
}
/**
  * @brief  LCD fill display buffer.
  * @param  flushbuf:buffer start address.
  * @param  idx: display digital index
  * @param  number: number 0x0 ~ 0x0F
  * @retval None.
  */
void lcd_display(uint32_t *flushbuf, uint8_t idx, uint8_t number)
{

}
/**
  * @brief  Reflush the used com_seg buffer.
  * @param  srcbuf:the source data start address.
  * @retval None.
  */
void lcd_reflush(lcd_handle_t *hperh, uint32_t *flushbuf)
{

}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    /* Initialize ALD */
    ald_cmu_init();

    /* Configure system clock */
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);

    /* Enable peripheral clock */
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

    lcd_init(&h_lcd);
    ald_lcd_write(&h_lcd, 0, reg_seg_A | reg_seg_B | reg_seg_C | reg_seg_D | reg_seg_E | reg_seg_F | reg_seg_G | reg_seg_H);
    ald_lcd_write(&h_lcd, 1, reg_seg_A | reg_seg_B | reg_seg_C | reg_seg_D | reg_seg_E | reg_seg_F | reg_seg_G | reg_seg_H);
    ald_lcd_write(&h_lcd, 2, reg_seg_A | reg_seg_B | reg_seg_C | reg_seg_D | reg_seg_E | reg_seg_F | reg_seg_G | reg_seg_H);
    ald_lcd_write(&h_lcd, 3, reg_seg_A | reg_seg_B | reg_seg_C | reg_seg_D | reg_seg_E | reg_seg_F | reg_seg_G | reg_seg_H);
	
    while (1)
    {
        ;
    }
}

/**
  * @}
  */
/**
  * @}
  */
