/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0.2
  * @date    28 Apr 2022
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Apr 2021     AE Team         The first version
  *          26 Jan 2022     AE Team         Modify the page eraser function
  *          28 Apr 2022     AE Team         modify the system clock
    *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */

#include <string.h>
#include "main.h"
#include "ald_gpio.h"
#include "ald_cmu.h"
#include "ald_iap.h"


#define IAP_ADDR    0x10000
#define IAP_LEN     0x40

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
uint8_t tx_buf[512];
uint8_t rx_buf[512];
int32_t ret;
/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    int i;

    /* Initialize ALD */
    ald_cmu_init();

    /* Configure system clock */
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
    /* Enable all peripherals */
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

    memset(tx_buf, 0x55, 512);
    memset(rx_buf, 0x0, 512);

    /* Erase a page */
    ald_iap_erase_page(IAP_ADDR, 0);
    /* Write data to flash */
    ald_iap_program_words(IAP_ADDR, tx_buf, IAP_LEN, 0);

    /* Read data from flash */
    for (i = 0; i < IAP_LEN; ++i)
        rx_buf[i] = *(uint8_t *)(IAP_ADDR + i);

    /* Compare data */
    ret = memcmp(tx_buf, rx_buf, IAP_LEN);

    while (1)
    {
        ald_delay_ms(1000);
    }
}
/**
  * @}
  */
/**
  * @}
  */
