/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0.1
  * @date    28 Apr 2022
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Apr 2021     AE Team         The first version
  *          28 Apr 2022     AE Team         modify the system clock
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    gpio_init_t x;
    exti_init_t exti;

    /* Initialize ALD */
    ald_cmu_init();
    /* Configure system clock */
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

    /* Enable external interrupt */
    ald_mcu_irq_config(EXTI0_3_IRQn,  3, ENABLE);

    /* Initialize GPIO_PIN_0 as input */
    x.mode = GPIO_MODE_INPUT;
    x.odos = GPIO_PUSH_PULL;
    x.pupd = GPIO_PUSH_UP;
    x.podrv = GPIO_OUT_DRIVE_1;
    x.nodrv = GPIO_OUT_DRIVE_1;
    x.flt  = GPIO_FILTER_DISABLE;
    x.type = GPIO_TYPE_CMOS;
    x.func = GPIO_FUNC_1;
    ald_gpio_init(GPIOA, GPIO_PIN_0, &x);

    /* Initialize external interrupt */
    exti.filter      = ENABLE;
    exti.cks         = EXTI_FILTER_CLOCK_10K;
    exti.filter_time = 10;
    ald_gpio_exti_init(GPIOA, GPIO_PIN_0, &exti);

    /* Clear interrupt flag */
    ald_gpio_exti_clear_flag_status(GPIO_PIN_0);
    /* Configure interrupt */
    ald_gpio_exti_interrupt_config(GPIO_PIN_0, EXTI_TRIGGER_BOTH_EDGE, ENABLE);

    while (1)
    {
        ald_delay_ms(1000);
    }
}

/**
  * @brief  GPIO IRQ handler
  * @retval None
  */
void gpio_irq_handler(void)
{
    /* Check and clear interrupt flag */
    ald_gpio_exti_get_flag_status(GPIO_PIN_0);
    ald_gpio_exti_clear_flag_status(GPIO_PIN_0);
    return;
}

/**
  * @}
  */
/**
  * @}
  */
