/**
  *********************************************************************************
  *
  * @file    main.h
  * @brief   Header file for DEMO
  *
  * @version V1.0
  * @date    26 Apr 2021
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Apr 2021     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */

#ifndef __MAIN_H__
#define __MAIN_H__

#include "ald_conf.h"

#define  HRC_Standard_30  		*(uint32_t*)0x20980& 0x0000FFFF		//get 30 HRC frequency alibration default value in reg [0:15]
#define  HRC_Standard_85		*(uint32_t*)0x20990& 0x0000FFFF		//get 85 HRC frequency alibration default value in reg [0:15]
#define  ADCTemp_Standard_30	*(uint32_t*)0x20988 & 0x00000FFF	// get 30 temperature value in reg[0:11]
#define  ADCTemp_Standard_85	*(uint32_t*)0x20998 & 0x00000FFF	// get 85 temperature value in reg[0:11]
#define  HRC_Standard			*(uint32_t*)0x20840					// get 85 temperature value in reg[0:11]
#define  Reg_Address			0x40083C18	//use for decide which x will be used in inf[x]

/* IO pin definition */

#define UART_PORT_TX    GPIOB
#define UART_PIN_TX		GPIO_PIN_6
#define UART_FUNC_TX    GPIO_FUNC_2
#define UART_PORT_RX    GPIOB
#define UART_PIN_RX		GPIO_PIN_7
#define UART_FUNC_RX    GPIO_FUNC_2

extern adc_handle_t h_adc;

#endif
