/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Apr 2021
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Apr 2021     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include <string.h>
#include "main.h"
#include "ald_gpio.h"
#include "ald_cmu.h"


/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

void led_init(void)
{
	gpio_init_t x;
	x.mode = GPIO_MODE_OUTPUT;
	x.odos = GPIO_PUSH_PULL;
	x.pupd = GPIO_FLOATING;
	x.podrv = GPIO_OUT_DRIVE_1;
	x.nodrv = GPIO_OUT_DRIVE_1;
	x.flt  = GPIO_FILTER_DISABLE;
	x.type = GPIO_TYPE_TTL;
	x.func = GPIO_FUNC_1;
	ald_gpio_init(GPIOB, led_seg_G|led_seg_C|led_seg_E|led_seg_A|led_seg_F|led_seg_B, &x);
	
	x.mode = GPIO_MODE_OUTPUT;
	x.odos = GPIO_PUSH_PULL;
	x.pupd = GPIO_FLOATING;
	x.podrv = GPIO_OUT_DRIVE_20;
	x.nodrv = GPIO_OUT_DRIVE_20;
	x.flt  = GPIO_FILTER_DISABLE;
	x.type = GPIO_TYPE_TTL;
	x.func = GPIO_FUNC_1;
	ald_gpio_init(GPIOC, led_seg_H|led_seg_D|beep, &x);
	
	
	x.mode = GPIO_MODE_OUTPUT;
	x.odos = GPIO_PUSH_PULL;
	x.pupd = GPIO_FLOATING;
	x.podrv = GPIO_OUT_DRIVE_20;
	x.nodrv = GPIO_OUT_DRIVE_20;
	x.flt  = GPIO_FILTER_DISABLE;
	x.type = GPIO_TYPE_TTL;
	x.func = GPIO_FUNC_1;
	ald_gpio_init(GPIOB, led_com_4, &x);
	
	x.mode = GPIO_MODE_OUTPUT;
	x.odos = GPIO_PUSH_PULL;
	x.pupd = GPIO_FLOATING;
	x.podrv = GPIO_OUT_DRIVE_20;
	x.nodrv = GPIO_OUT_DRIVE_20;
	x.flt  = GPIO_FILTER_DISABLE;
	x.type = GPIO_TYPE_TTL;
	x.func = GPIO_FUNC_1;
	ald_gpio_init(GPIOA, led_com_1|led_com_2|led_com_3, &x);
	
}

void led_display(unsigned char digital, unsigned char comx)
{
	switch (comx) {
	case 1:
		ald_gpio_write_pin(GPIOA, led_com_1, 0);
		break;

	case 2:
		ald_gpio_write_pin(GPIOA, led_com_2, 0);
		break;
	
	case 3:
		ald_gpio_write_pin(GPIOA, led_com_3, 0);
		break;
	
	case 4:
		ald_gpio_write_pin(GPIOB, led_com_4, 0);
		break;

	default:
		break;
	}

	//A
	if ((digital == 0) || (digital == 2) || (digital == 3) || (digital == 5) ||
	   (digital == 6) || (digital == 7) || (digital == 8) || (digital == 9)) {
		ald_gpio_write_pin(GPIOB, led_seg_A, 1);
	}
	//B
	if ((digital == 0) || (digital == 1) || (digital == 2) || (digital == 3) || (digital == 4)||
	   (digital == 7) || (digital == 8) || (digital == 9)) {
		ald_gpio_write_pin(GPIOB, led_seg_B, 1);
	}
	//C
	if ((digital == 0) || (digital == 1) || (digital == 3) || (digital == 4) ||
	   (digital == 5) || (digital == 6) || (digital == 7) || (digital == 8) || (digital==9)) {
		ald_gpio_write_pin(GPIOB, led_seg_C, 1);
	}
	//D
	if ((digital == 0) || (digital == 2) || (digital == 3) || (digital == 5) ||
	   (digital == 6) || (digital == 8) || (digital == 9)) {
		ald_gpio_write_pin(GPIOC, led_seg_D, 1);
	}
	//E
	if ((digital == 0) || (digital == 2) || (digital == 6) || (digital == 8)) {
		ald_gpio_write_pin(GPIOB, led_seg_E, 1);
	}
	//F
	if ((digital == 0) || (digital == 4) || (digital == 5) || (digital == 6) ||
	   (digital == 8) || (digital == 9)) {
		ald_gpio_write_pin(GPIOB, led_seg_F, 1);
	}
	//G
	if ((digital == 2) || (digital == 3) || (digital == 4) || (digital == 5) ||
	   (digital == 6) || (digital == 8) || (digital == 9)) {
		ald_gpio_write_pin(GPIOB, led_seg_G, 1);
	}	
}
void clear_display(void)
{
	ald_gpio_write_pin(GPIOA, led_com_1, 1);
	ald_gpio_write_pin(GPIOA, led_com_2, 1);
	ald_gpio_write_pin(GPIOA, led_com_3, 1);
	ald_gpio_write_pin(GPIOB, led_com_4, 1);
	
	ald_gpio_write_pin(GPIOB, led_seg_A, 0);
	ald_gpio_write_pin(GPIOB, led_seg_B, 0);
	ald_gpio_write_pin(GPIOB, led_seg_C, 0);
	ald_gpio_write_pin(GPIOC, led_seg_D, 0);
	ald_gpio_write_pin(GPIOB, led_seg_E, 0);
	ald_gpio_write_pin(GPIOB, led_seg_F, 0);
	ald_gpio_write_pin(GPIOB, led_seg_G, 0);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	unsigned char i,j;

	/* Initialize ALD */
	ald_cmu_init();
	/* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
	/* Enable peripheral clock */
	ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

	led_init();
	
	while (1){
		for (j = 1; j < 5; j++) {
			for (i = 0;i < 10; i++) {
				led_display(i, j);
				ald_gpio_write_pin(GPIOC, beep, 0);
				ald_delay_ms(995);
				clear_display();
				ald_gpio_write_pin(GPIOC, beep, 1);
				ald_delay_ms(5);
			}
		}
	}
}

/**
  * @}
  */
/**
  * @}
  */
