/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */ 

#include <string.h>
#include <rtthread.h>
#include "main.h"

#define THREAD_STACK_SIZE	256
#define THREAD_PRIORITY		8

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

static struct rt_thread *tid1 = RT_NULL;
static struct rt_thread *tid2 = RT_NULL;
static struct rt_mailbox *mb;
static char mb_str1[] = "I'm a mail!";
static char mb_str2[] = "this is another mail!";

static void thread1_entry(void* parameter)
{
	unsigned char* str;

	while (1) {
		rt_kprintf("thread1: try to recv a mail\n");

		if (rt_mb_recv(mb, (rt_ubase_t *)&str, RT_WAITING_FOREVER) == RT_EOK) {
			rt_kprintf("thread1: get a mail from mailbox, the content:%s\n", str);
			rt_thread_delay(100);
		}
	}
}

static void thread2_entry(void* parameter)
{
	rt_uint8_t count = 0;

	while (1) {
		++count;

		if (count & 0x1)
			rt_mb_send(mb, (rt_uint32_t)&mb_str1[0]);
		else
			rt_mb_send(mb, (rt_uint32_t)&mb_str2[0]);

		rt_thread_delay(200);
	}
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	mb = rt_mb_create("mbt", 64, RT_IPC_FLAG_FIFO);

	tid1 = rt_thread_create("t1", thread1_entry, RT_NULL,
                            THREAD_STACK_SIZE, THREAD_PRIORITY, 5);
	if (tid1 != RT_NULL)
		rt_thread_startup(tid1);

	tid2 = rt_thread_create("t2", thread2_entry, RT_NULL,
                            THREAD_STACK_SIZE, THREAD_PRIORITY, 5);
	if (tid2 != RT_NULL)
		rt_thread_startup(tid2);

	return 0;
}

/**
  * @}
  */
/**
  * @}
  */
