/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */ 

#include <string.h>
#include <rtthread.h>
#include "main.h"

#define THREAD_STACK_SIZE	256
#define THREAD_PRIORITY		8

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

static struct rt_thread *tid1 = RT_NULL;
static struct rt_thread *tid2 = RT_NULL;
static struct rt_thread *tid3 = RT_NULL;
static struct rt_event *event;


static void thread1_entry(void *param)
{
	rt_uint32_t e;

	while (1) {
		/* receive first event */
		if (rt_event_recv(event, ((1 << 3) | (1 << 5)),
				RT_EVENT_FLAG_AND | RT_EVENT_FLAG_CLEAR,
				RT_WAITING_FOREVER, &e) == RT_EOK) {
			rt_kprintf("thread1: AND recv event 0x%x\n", e);
		}

		rt_kprintf("thread1: delay 1s to prepare second event\n");
		rt_thread_delay(100);

		/* receive second event */
		if (rt_event_recv(event, ((1 << 3) | (1 << 5)),
				RT_EVENT_FLAG_OR | RT_EVENT_FLAG_CLEAR,
				RT_WAITING_FOREVER, &e) == RT_EOK) {
			rt_kprintf("thread1: OR recv event 0x%x\n", e);
		}

		rt_thread_delay(5);
	}
}

static void thread2_entry(void *param)
{
	while (1) {
		rt_kprintf("thread2: send event1\n");
		rt_event_send(event, (1 << 3));

		rt_thread_delay(10);
	}
}

static void thread3_entry(void *param)
{
	while (1) {
		rt_kprintf("thread3: send event2\n");
		rt_event_send(event, (1 << 5));

		rt_thread_delay(20);
	}
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	event = rt_event_create("event", RT_IPC_FLAG_FIFO);

	tid1 = rt_thread_create("t1", thread1_entry, RT_NULL,
                            THREAD_STACK_SIZE, THREAD_PRIORITY, 5);
	if (tid1 != RT_NULL)
		rt_thread_startup(tid1);

	tid2 = rt_thread_create("t2", thread2_entry, RT_NULL,
                            THREAD_STACK_SIZE, THREAD_PRIORITY, 5);
	if (tid2 != RT_NULL)
		rt_thread_startup(tid2);

	tid3 = rt_thread_create("t3", thread3_entry, RT_NULL,
                            THREAD_STACK_SIZE, THREAD_PRIORITY, 5);
	if (tid3 != RT_NULL)
		rt_thread_startup(tid3);

	return 0;
}

/**
  * @}
  */
/**
  * @}
  */
