/**
  *********************************************************************************
  *
  * @file    lcd.c
  * @brief   LCD display function
  *
  * @version V1.0.0
  * @date    13 May 2022
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          13 May 2022     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  *********************************************************************************
  */

#include "lcd.h"
#include "ald_gpio.h"
#include "ald_lcd.h"

lcd_handle_t h_lcd;

const uint32_t COM1_1[] =
{
    COM1_NUM_1_0,
    COM1_NUM_1_1,
    COM1_NUM_1_2,
    COM1_NUM_1_3,
    COM1_NUM_1_4,
    COM1_NUM_1_5,
    COM1_NUM_1_6,
    COM1_NUM_1_7,
    COM1_NUM_1_8,
    COM1_NUM_1_9,
};

const uint32_t COM2_1[] =
{
    COM2_NUM_1_0,
    COM2_NUM_1_1,
    COM2_NUM_1_2,
    COM2_NUM_1_3,
    COM2_NUM_1_4,
    COM2_NUM_1_5,
    COM2_NUM_1_6,
    COM2_NUM_1_7,
    COM2_NUM_1_8,
    COM2_NUM_1_9,
};

const uint32_t COM3_1[] =
{
    COM3_NUM_1_0,
    COM3_NUM_1_1,
    COM3_NUM_1_2,
    COM3_NUM_1_3,
    COM3_NUM_1_4,
    COM3_NUM_1_5,
    COM3_NUM_1_6,
    COM3_NUM_1_7,
    COM3_NUM_1_8,
    COM3_NUM_1_9,
};

const uint32_t COM4_1[] =
{
    COM4_NUM_1_0,
    COM4_NUM_1_1,
    COM4_NUM_1_2,
    COM4_NUM_1_3,
    COM4_NUM_1_4,
    COM4_NUM_1_5,
    COM4_NUM_1_6,
    COM4_NUM_1_7,
    COM4_NUM_1_8,
    COM4_NUM_1_9,
};

const uint32_t COM1_2[] =
{
    COM1_NUM_2_0,
    COM1_NUM_2_1,
    COM1_NUM_2_2,
    COM1_NUM_2_3,
    COM1_NUM_2_4,
    COM1_NUM_2_5,
    COM1_NUM_2_6,
    COM1_NUM_2_7,
    COM1_NUM_2_8,
    COM1_NUM_2_9,
};

const uint32_t COM2_2[] =
{
    COM2_NUM_2_0,
    COM2_NUM_2_1,
    COM2_NUM_2_2,
    COM2_NUM_2_3,
    COM2_NUM_2_4,
    COM2_NUM_2_5,
    COM2_NUM_2_6,
    COM2_NUM_2_7,
    COM2_NUM_2_8,
    COM2_NUM_2_9,
};

const uint32_t COM3_2[] =
{
    COM3_NUM_2_0,
    COM3_NUM_2_1,
    COM3_NUM_2_2,
    COM3_NUM_2_3,
    COM3_NUM_2_4,
    COM3_NUM_2_5,
    COM3_NUM_2_6,
    COM3_NUM_2_7,
    COM3_NUM_2_8,
    COM3_NUM_2_9,
};

const uint32_t COM4_2[] =
{
    COM4_NUM_2_0,
    COM4_NUM_2_1,
    COM4_NUM_2_2,
    COM4_NUM_2_3,
    COM4_NUM_2_4,
    COM4_NUM_2_5,
    COM4_NUM_2_6,
    COM4_NUM_2_7,
    COM4_NUM_2_8,
    COM4_NUM_2_9,
};

const uint32_t COM1_3[] =
{
    COM1_NUM_3_0,
    COM1_NUM_3_1,
    COM1_NUM_3_2,
    COM1_NUM_3_3,
    COM1_NUM_3_4,
    COM1_NUM_3_5,
    COM1_NUM_3_6,
    COM1_NUM_3_7,
    COM1_NUM_3_8,
    COM1_NUM_3_9,
};

const uint32_t COM2_3[] =
{
    COM2_NUM_3_0,
    COM2_NUM_3_1,
    COM2_NUM_3_2,
    COM2_NUM_3_3,
    COM2_NUM_3_4,
    COM2_NUM_3_5,
    COM2_NUM_3_6,
    COM2_NUM_3_7,
    COM2_NUM_3_8,
    COM2_NUM_3_9,
};

const uint32_t COM3_3[] =
{
    COM3_NUM_3_0,
    COM3_NUM_3_1,
    COM3_NUM_3_2,
    COM3_NUM_3_3,
    COM3_NUM_3_4,
    COM3_NUM_3_5,
    COM3_NUM_3_6,
    COM3_NUM_3_7,
    COM3_NUM_3_8,
    COM3_NUM_3_9,
};

const uint32_t COM4_3[] =
{
    COM4_NUM_3_0,
    COM4_NUM_3_1,
    COM4_NUM_3_2,
    COM4_NUM_3_3,
    COM4_NUM_3_4,
    COM4_NUM_3_5,
    COM4_NUM_3_6,
    COM4_NUM_3_7,
    COM4_NUM_3_8,
    COM4_NUM_3_9,
};

const uint32_t COM1_4[] =
{
    COM1_NUM_4_0,
    COM1_NUM_4_1,
    COM1_NUM_4_2,
    COM1_NUM_4_3,
    COM1_NUM_4_4,
    COM1_NUM_4_5,
    COM1_NUM_4_6,
    COM1_NUM_4_7,
    COM1_NUM_4_8,
    COM1_NUM_4_9,
};

const uint32_t COM2_4[] =
{
    COM2_NUM_4_0,
    COM2_NUM_4_1,
    COM2_NUM_4_2,
    COM2_NUM_4_3,
    COM2_NUM_4_4,
    COM2_NUM_4_5,
    COM2_NUM_4_6,
    COM2_NUM_4_7,
    COM2_NUM_4_8,
    COM2_NUM_4_9,
};

const uint32_t COM3_4[] =
{
    COM3_NUM_4_0,
    COM3_NUM_4_1,
    COM3_NUM_4_2,
    COM3_NUM_4_3,
    COM3_NUM_4_4,
    COM3_NUM_4_5,
    COM3_NUM_4_6,
    COM3_NUM_4_7,
    COM3_NUM_4_8,
    COM3_NUM_4_9,
};

const uint32_t COM4_4[] =
{
    COM4_NUM_4_0,
    COM4_NUM_4_1,
    COM4_NUM_4_2,
    COM4_NUM_4_3,
    COM4_NUM_4_4,
    COM4_NUM_4_5,
    COM4_NUM_4_6,
    COM4_NUM_4_7,
    COM4_NUM_4_8,
    COM4_NUM_4_9,
};

void led_pin_init(void)
{
    gpio_init_t x;

    /* Enable peripheral clock */
    ald_cmu_perh_clock_config(CMU_PERH_GPIO, ENABLE);

    x.mode = GPIO_MODE_CLOSE;
    x.odos = GPIO_PUSH_PULL;
    x.pupd = GPIO_FLOATING;
    x.podrv = GPIO_OUT_DRIVE_20;
    x.nodrv = GPIO_OUT_DRIVE_20;
    x.flt  = GPIO_FILTER_DISABLE;
    x.type = GPIO_TYPE_CMOS;
    x.func = GPIO_FUNC_0;
    ald_gpio_init(GPIOA, led_com_0 | led_com_1 | led_com_2 | led_seg_16 | led_seg_17 | led_seg_18, &x);

    x.mode = GPIO_MODE_CLOSE;
    x.odos = GPIO_PUSH_PULL;
    x.pupd = GPIO_FLOATING;
    x.podrv = GPIO_OUT_DRIVE_20;
    x.nodrv = GPIO_OUT_DRIVE_20;
    x.flt  = GPIO_FILTER_DISABLE;
    x.type = GPIO_TYPE_CMOS;
    x.func = GPIO_FUNC_0;
    ald_gpio_init(GPIOB, led_com_3 | led_seg_28 | led_seg_19 | led_seg_14 | led_seg_15, &x);

    x.mode = GPIO_MODE_CLOSE;
    x.odos = GPIO_PUSH_PULL;
    x.pupd = GPIO_FLOATING;
    x.podrv = GPIO_OUT_DRIVE_20;
    x.nodrv = GPIO_OUT_DRIVE_20;
    x.flt  = GPIO_FILTER_DISABLE;
    x.type = GPIO_TYPE_CMOS;
    x.func = GPIO_FUNC_0;
    ald_gpio_init(GPIOC, led_seg_20, &x);
}

void lcd_num_dis(uint8_t data_1, uint8_t data_2, uint8_t data_3, uint8_t data_4)
{
    ald_lcd_write(&h_lcd, COM1, (COM1_1[data_1] | COM1_2[data_2] | COM1_3[data_3] | COM1_4[data_4]));
    ald_lcd_write(&h_lcd, COM2, (COM2_1[data_1] | COM2_2[data_2] | COM2_3[data_3] | COM2_4[data_4]));
    ald_lcd_write(&h_lcd, COM3, (COM3_1[data_1] | COM3_2[data_2] | COM3_3[data_3] | COM3_4[data_4]));
    ald_lcd_write(&h_lcd, COM4, (COM4_1[data_1] | COM4_2[data_2] | COM4_3[data_3] | COM4_4[data_4]));
}

void lcd_init(void)
{
    /* Enable peripheral clock */
    ald_cmu_perh_clock_config(CMU_PERH_LCD, ENABLE);

    led_pin_init();

    /* Initialize lcd */
    h_lcd.perh = LCD;
    h_lcd.init.lcd_bias   = LCD_BIAS_1_3;
    h_lcd.init.lcd_div    = LCD_DIV_20;
    h_lcd.init.lcd_duty   = LCD_DUTY_1_4;
    h_lcd.init.lcd_prs    = LCD_PRS_4;
    h_lcd.init.lcd_dsld   = 0xF;
    h_lcd.init.lcd_dshd   = 0xF;
    h_lcd.init.lcd_reshd  = LCD_RES_1MOHM;
    h_lcd.init.lcd_resld  = LCD_RES_1MOHM;
    h_lcd.init.lcd_vbufhd = LCD_FUNC_ENABLE;
    h_lcd.init.lcd_vbufld = LCD_FUNC_DISABLE;
    h_lcd.init.lcd_vchps  = LCD_VCHPS_3V2;
    h_lcd.init.lcd_vsel   = LCD_VSEL_VDD;
    h_lcd.init.lcd_wfs    = LCD_WAVE_A;
    h_lcd.init.lcd_vgs    = LCD_VGS_0;
    h_lcd.init.clock      = CMU_LCD_SEL_LRC;
    ald_lcd_init(&h_lcd);

    //PB15   PB14  PA11  PA12  PA15  PB3   PB7   PC7
    /* seg15 seg14 seg16 seg17 seg18 seg28 seg19 seg20 */
    ald_lcd_write_seg(&h_lcd, 0x101FC000);
    /* Enable lcd */
    ald_lcd_cmd(&h_lcd, ENABLE);

    ald_lcd_write(&h_lcd, COM1, 0x101FC000);
    ald_lcd_write(&h_lcd, COM2, 0x101FC000);
    ald_lcd_write(&h_lcd, COM3, 0x101FC000);
    ald_lcd_write(&h_lcd, COM4, 0x101FC000);
}
