/**
  *********************************************************************************
  *
  * @file    lcd.h
  * @brief   Header file for DEMO
  *
  * @version V1.0
  * @date    13 May 2022
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          13 May 2022     AE Team         The first version
    *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  *********************************************************************************
  */

#ifndef   __LCD_H__
#define   __LCD_H__

#include "utils.h"

//#define GPIOA
#define     led_com_0   GPIO_PIN_8
#define     led_com_1   GPIO_PIN_9
#define     led_com_2   GPIO_PIN_10

#define     led_seg_16  GPIO_PIN_11
#define     led_seg_17  GPIO_PIN_12
#define     led_seg_18  GPIO_PIN_15

//#define GPIOB
#define     led_com_3   GPIO_PIN_9

#define     led_seg_28  GPIO_PIN_3
#define     led_seg_19  GPIO_PIN_7
#define     led_seg_14  GPIO_PIN_14
#define     led_seg_15  GPIO_PIN_15

//#define GPIOC
#define     led_seg_20  GPIO_PIN_7

#define     COM1        2
#define     COM2        1
#define     COM3        0
#define     COM4        3

#define     SEG_1_A                0x00008000
#define     SEG_1_B                0x00004000
#define     SEG_1_F                0x00008000
#define     SEG_1_G                0x00004000
#define     SEG_1_E                0x00008000
#define     SEG_1_C                0x00004000
#define     SEG_1_D                0x00004000
#define     COM1_NUM_1_0           (SEG_1_A|SEG_1_B)
#define     COM2_NUM_1_0           (SEG_1_F)
#define     COM3_NUM_1_0           (SEG_1_E|SEG_1_C)
#define     COM4_NUM_1_0           (SEG_1_D)
#define     COM1_NUM_1_1           (SEG_1_B)
#define     COM2_NUM_1_1           (0x00000000)
#define     COM3_NUM_1_1           (SEG_1_C)
#define     COM4_NUM_1_1           (0x00000000)
#define     COM1_NUM_1_2           (SEG_1_A|SEG_1_B)
#define     COM2_NUM_1_2           (SEG_1_G)
#define     COM3_NUM_1_2           (SEG_1_E)
#define     COM4_NUM_1_2           (SEG_1_D)
#define     COM1_NUM_1_3           (SEG_1_A|SEG_1_B)
#define     COM2_NUM_1_3           (SEG_1_G)
#define     COM3_NUM_1_3           (SEG_1_C)
#define     COM4_NUM_1_3           (SEG_1_D)
#define     COM1_NUM_1_4           (SEG_1_B)
#define     COM2_NUM_1_4           (SEG_1_F|SEG_1_G)
#define     COM3_NUM_1_4           (SEG_1_C)
#define     COM4_NUM_1_4           (0x00000000)
#define     COM1_NUM_1_5           (SEG_1_A)
#define     COM2_NUM_1_5           (SEG_1_F|SEG_1_G)
#define     COM3_NUM_1_5           (SEG_1_C)
#define     COM4_NUM_1_5           (SEG_1_D)
#define     COM1_NUM_1_6           (SEG_1_A)
#define     COM2_NUM_1_6           (SEG_1_F|SEG_1_G)
#define     COM3_NUM_1_6           (SEG_1_E|SEG_1_C)
#define     COM4_NUM_1_6           (SEG_1_D)
#define     COM1_NUM_1_7           (SEG_1_A|SEG_1_B)
#define     COM2_NUM_1_7           (0x00000000)
#define     COM3_NUM_1_7           (SEG_1_C)
#define     COM4_NUM_1_7           (0x00000000)
#define     COM1_NUM_1_8           (SEG_1_A|SEG_1_B)
#define     COM2_NUM_1_8           (SEG_1_F|SEG_1_G)
#define     COM3_NUM_1_8           (SEG_1_E|SEG_1_C)
#define     COM4_NUM_1_8           (SEG_1_D)
#define     COM1_NUM_1_9           (SEG_1_A|SEG_1_B)
#define     COM2_NUM_1_9           (SEG_1_F|SEG_1_G)
#define     COM3_NUM_1_9           (SEG_1_C)
#define     COM4_NUM_1_9           (SEG_1_D)

#define     SEG_2_A                0x00010000
#define     SEG_2_B                0x00020000
#define     SEG_2_F                0x00010000
#define     SEG_2_G                0x00020000
#define     SEG_2_E                0x00010000
#define     SEG_2_C                0x00020000
#define     SEG_2_D                0x00020000
#define     COM1_NUM_2_0           (SEG_2_A|SEG_2_B)
#define     COM2_NUM_2_0           (SEG_2_F)
#define     COM3_NUM_2_0           (SEG_2_E|SEG_2_C)
#define     COM4_NUM_2_0           (SEG_2_D)
#define     COM1_NUM_2_1           (SEG_2_B)
#define     COM2_NUM_2_1           (0x00000000)
#define     COM3_NUM_2_1           (SEG_2_C)
#define     COM4_NUM_2_1           (0x00000000)
#define     COM1_NUM_2_2           (SEG_2_A|SEG_2_B)
#define     COM2_NUM_2_2           (SEG_2_G)
#define     COM3_NUM_2_2           (SEG_2_E)
#define     COM4_NUM_2_2           (SEG_2_D)
#define     COM1_NUM_2_3           (SEG_2_A|SEG_2_B)
#define     COM2_NUM_2_3           (SEG_2_G)
#define     COM3_NUM_2_3           (SEG_2_C)
#define     COM4_NUM_2_3           (SEG_2_D)
#define     COM1_NUM_2_4           (SEG_2_B)
#define     COM2_NUM_2_4           (SEG_2_F|SEG_2_G)
#define     COM3_NUM_2_4           (SEG_2_C)
#define     COM4_NUM_2_4           (0x00000000)
#define     COM1_NUM_2_5           (SEG_2_A)
#define     COM2_NUM_2_5           (SEG_2_F|SEG_2_G)
#define     COM3_NUM_2_5           (SEG_2_C)
#define     COM4_NUM_2_5           (SEG_2_D)
#define     COM1_NUM_2_6           (SEG_2_A)
#define     COM2_NUM_2_6           (SEG_2_F|SEG_2_G)
#define     COM3_NUM_2_6           (SEG_2_E|SEG_2_C)
#define     COM4_NUM_2_6           (SEG_2_D)
#define     COM1_NUM_2_7           (SEG_2_A|SEG_2_B)
#define     COM2_NUM_2_7           (0x00000000)
#define     COM3_NUM_2_7           (SEG_2_C)
#define     COM4_NUM_2_7           (0x00000000)
#define     COM1_NUM_2_8           (SEG_2_A|SEG_2_B)
#define     COM2_NUM_2_8           (SEG_2_F|SEG_2_G)
#define     COM3_NUM_2_8           (SEG_2_E|SEG_2_C)
#define     COM4_NUM_2_8           (SEG_2_D)
#define     COM1_NUM_2_9           (SEG_2_A|SEG_2_B)
#define     COM2_NUM_2_9           (SEG_2_F|SEG_2_G)
#define     COM3_NUM_2_9           (SEG_2_C)
#define     COM4_NUM_2_9           (SEG_2_D)

#define     SEG_3_A                0x00040000
#define     SEG_3_B                0x10000000
#define     SEG_3_F                0x00040000
#define     SEG_3_G                0x10000000
#define     SEG_3_E                0x00040000
#define     SEG_3_C                0x10000000
#define     SEG_3_D                0x10000000
#define     COM1_NUM_3_0           (SEG_3_A|SEG_3_B)
#define     COM2_NUM_3_0           (SEG_3_F)
#define     COM3_NUM_3_0           (SEG_3_E|SEG_3_C)
#define     COM4_NUM_3_0           (SEG_3_D)
#define     COM1_NUM_3_1           (SEG_3_B)
#define     COM2_NUM_3_1           (0x00000000)
#define     COM3_NUM_3_1           (SEG_3_C)
#define     COM4_NUM_3_1           (0x00000000)
#define     COM1_NUM_3_2           (SEG_3_A|SEG_3_B)
#define     COM2_NUM_3_2           (SEG_3_G)
#define     COM3_NUM_3_2           (SEG_3_E)
#define     COM4_NUM_3_2           (SEG_3_D)
#define     COM1_NUM_3_3           (SEG_3_A|SEG_3_B)
#define     COM2_NUM_3_3           (SEG_3_G)
#define     COM3_NUM_3_3           (SEG_3_C)
#define     COM4_NUM_3_3           (SEG_3_D)
#define     COM1_NUM_3_4           (SEG_3_B)
#define     COM2_NUM_3_4           (SEG_3_F|SEG_3_G)
#define     COM3_NUM_3_4           (SEG_3_C)
#define     COM4_NUM_3_4           (0x00000000)
#define     COM1_NUM_3_5           (SEG_3_A)
#define     COM2_NUM_3_5           (SEG_3_F|SEG_3_G)
#define     COM3_NUM_3_5           (SEG_3_C)
#define     COM4_NUM_3_5           (SEG_3_D)
#define     COM1_NUM_3_6           (SEG_3_A)
#define     COM2_NUM_3_6           (SEG_3_F|SEG_3_G)
#define     COM3_NUM_3_6           (SEG_3_E|SEG_3_C)
#define     COM4_NUM_3_6           (SEG_3_D)
#define     COM1_NUM_3_7           (SEG_3_A|SEG_3_B)
#define     COM2_NUM_3_7           (0x00000000)
#define     COM3_NUM_3_7           (SEG_3_C)
#define     COM4_NUM_3_7           (0x00000000)
#define     COM1_NUM_3_8           (SEG_3_A|SEG_3_B)
#define     COM2_NUM_3_8           (SEG_3_F|SEG_3_G)
#define     COM3_NUM_3_8           (SEG_3_E|SEG_3_C)
#define     COM4_NUM_3_8           (SEG_3_D)
#define     COM1_NUM_3_9           (SEG_3_A|SEG_3_B)
#define     COM2_NUM_3_9           (SEG_3_F|SEG_3_G)
#define     COM3_NUM_3_9           (SEG_3_C)
#define     COM4_NUM_3_9           (SEG_3_D)

#define     SEG_4_A                0x00080000
#define     SEG_4_B                0x00100000
#define     SEG_4_F                0x00080000
#define     SEG_4_G                0x00100000
#define     SEG_4_E                0x00080000
#define     SEG_4_C                0x00100000
#define     SEG_4_D                0x00100000
#define     COM1_NUM_4_0           (SEG_4_A|SEG_4_B)
#define     COM2_NUM_4_0           (SEG_4_F)
#define     COM3_NUM_4_0           (SEG_4_E|SEG_4_C)
#define     COM4_NUM_4_0           (SEG_4_D)
#define     COM1_NUM_4_1           (SEG_4_B)
#define     COM2_NUM_4_1           (0x00000000)
#define     COM3_NUM_4_1           (SEG_4_C)
#define     COM4_NUM_4_1           (0x00000000)
#define     COM1_NUM_4_2           (SEG_4_A|SEG_4_B)
#define     COM2_NUM_4_2           (SEG_4_G)
#define     COM3_NUM_4_2           (SEG_4_E)
#define     COM4_NUM_4_2           (SEG_4_D)
#define     COM1_NUM_4_3           (SEG_4_A|SEG_4_B)
#define     COM2_NUM_4_3           (SEG_4_G)
#define     COM3_NUM_4_3           (SEG_4_C)
#define     COM4_NUM_4_3           (SEG_4_D)
#define     COM1_NUM_4_4           (SEG_4_B)
#define     COM2_NUM_4_4           (SEG_4_F|SEG_4_G)
#define     COM3_NUM_4_4           (SEG_4_C)
#define     COM4_NUM_4_4           (0x00000000)
#define     COM1_NUM_4_5           (SEG_4_A)
#define     COM2_NUM_4_5           (SEG_4_F|SEG_4_G)
#define     COM3_NUM_4_5           (SEG_4_C)
#define     COM4_NUM_4_5           (SEG_4_D)
#define     COM1_NUM_4_6           (SEG_4_A)
#define     COM2_NUM_4_6           (SEG_4_F|SEG_4_G)
#define     COM3_NUM_4_6           (SEG_4_E|SEG_4_C)
#define     COM4_NUM_4_6           (SEG_4_D)
#define     COM1_NUM_4_7           (SEG_4_A|SEG_4_B)
#define     COM2_NUM_4_7           (0x00000000)
#define     COM3_NUM_4_7           (SEG_4_C)
#define     COM4_NUM_4_7           (0x00000000)
#define     COM1_NUM_4_8           (SEG_4_A|SEG_4_B)
#define     COM2_NUM_4_8           (SEG_4_F|SEG_4_G)
#define     COM3_NUM_4_8           (SEG_4_E|SEG_4_C)
#define     COM4_NUM_4_8           (SEG_4_D)
#define     COM1_NUM_4_9           (SEG_4_A|SEG_4_B)
#define     COM2_NUM_4_9           (SEG_4_F|SEG_4_G)
#define     COM3_NUM_4_9           (SEG_4_C)
#define     COM4_NUM_4_9           (SEG_4_D)

extern const uint32_t COM1_1[];
extern const uint32_t COM2_1[];
extern const uint32_t COM3_1[];
extern const uint32_t COM4_1[];
extern const uint32_t COM1_2[];
extern const uint32_t COM2_2[];
extern const uint32_t COM3_2[];
extern const uint32_t COM4_2[];
extern const uint32_t COM1_3[];
extern const uint32_t COM2_3[];
extern const uint32_t COM3_3[];
extern const uint32_t COM4_3[];
extern const uint32_t COM1_4[];
extern const uint32_t COM2_4[];
extern const uint32_t COM3_4[];
extern const uint32_t COM4_4[];

extern void lcd_num_dis(uint8_t data_1, uint8_t data_2, uint8_t data_3, uint8_t data_4);
extern void lcd_init(void);

#endif
