/**
  *********************************************************************************
  *
  * @file    pis.c
  * @brief   pis moudle for DEMO
  *
  * @version V1.0
  * @date    26 Apr 2021
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Apr 2021     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */

#include <string.h>
#include "ald_cmu.h"
#include "ald_pis.h"
#include "ald_gpio.h"
#include "pis.h"

pis_handle_t h_pis;

/**
  * @brief  Initializate pin of pis module.
  * @retval None
  */
void pis_pin_init(void)
{
    gpio_init_t x;
    memset(&x, 0x0, sizeof(x));

    ald_cmu_perh_clock_config(CMU_PERH_GPIO, ENABLE);

    /* Initialize GPIO_PIN_15 sa output */
    x.mode = GPIO_MODE_OUTPUT;
    x.odos = GPIO_PUSH_PULL;
    x.pupd = GPIO_PUSH_UP;
    x.podrv = GPIO_OUT_DRIVE_1;
    x.nodrv = GPIO_OUT_DRIVE_1;
    x.flt  = GPIO_FILTER_DISABLE;
    x.type = GPIO_TYPE_CMOS;
    x.func = GPIO_FUNC_7;
    ald_gpio_init(GPIOA, GPIO_PIN_15, &x);
}

void PIS_Init(void)
{
    pis_pin_init();//for test

    ald_cmu_perh_clock_config(CMU_PERH_PIS, ENABLE);

    /* Clear pis_handle_t struct */
    memset(&h_pis, 0, sizeof(pis_handle_t));

    /* Initialize PIS */
    h_pis.perh               = PIS;
    h_pis.init.producer_src  = PIS_FDET;
    h_pis.init.producer_clk  = PIS_CLK_LP;
    h_pis.init.producer_edge = PIS_EDGE_NONE;
    h_pis.init.consumer_trig = PIS_CH1_GP16C4T0_CH1IN;
    h_pis.init.consumer_clk  = PIS_CLK_PCLK1;
    ald_pis_create(&h_pis);

    /* for test */
    ald_pis_output_start(&h_pis, PIS_OUT_CH_1);
}
