/**
  ********************************************************************************
  *
  * @file    boot_flash.h
  * @brief   Head file of boot flash module.
  *
  * @version V1.0
  * @date    31 Dec 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          31 Dec 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */
#ifndef __BOOT_Flash_H__
#define __BOOT_Flash_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "ald_iap.h"
#include "boot.h"


/** @addtogroup Bootloader
  * @{
  */

/** @addtogroup Flash
  * @{
  */

/** @addtogroup Frame_Public_Macros Public Macros
  * @brief      Flash Public Macros
  * @{
  */

#define BOOT_FLASH_S        0x0
#define BOOT_FLASH_E        0x7FFF
#define APP_FLASH_S_0       0x8000
#define APP_FLASH_E_0       0x13FFF
#define APP_FLASH_S_1       0x14000
#define APP_FLASH_E_1       0x1FFFF
#define APP_FLASH_SIZE      0x400
#define OFFSET_VTOR_FLASH   0x8000
#define __MAIN              0x80C0


#define USR_FLASH_ADDER(x)  ((x) * APP_FLASH_SIZE + APP_FLASH_S_1)
/**
  * @}
  */

/** @addtogroup Flash_Public_Functions
  * @{
  */
extern uint32_t flash_usr_page_get(void);
extern int flash_usr_page_erase(void);
extern int write_data_to_flash(uint8_t page, uint8_t *data, uint16_t crc);
/**
  * @}
  */
/**
  * @}
  */

/**
  * @}
  */
#ifdef __cplusplus
extern "C"
}
#endif
#endif
