#include "boot_crc.h"


unsigned int crc_table[256];
#define K_CRC_POLY      0xEDB88320

void init_crc_table()
{
	int i, j;
	unsigned int r;
	
	for (i = 0; i < 256; ++i) {
		r = i;
		
		for (j = 0; j < 8; ++j)
			if (r & 1)
				r = (r >> 1) ^ K_CRC_POLY;
			else
				r >>= 1;
		
		crc_table[i] = r;
	}
}


unsigned int crc_update(unsigned char *data, unsigned int size)
{
	unsigned int crc = 0xffffffff;
	unsigned char *p = data;
	
	for (; size > 0 ; --size, ++p) {
		crc = crc_table[((unsigned char)crc) ^ *p] ^ (crc >> 8);
	}
	
	return crc;
}


unsigned int crc_digest(unsigned char *data, unsigned int size)
{
	unsigned int crc;
	
	init_crc_table();
	crc = crc_update(data, size);
	
	return crc ^ 0xffffffff;
}

