/**
  ********************************************************************************
  *
  * @file    boot.h
  * @brief   Head file of boot module.
  *
  * @version V1.0
  * @date    31 Dec 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          31 Dec 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */
#ifndef __BOOT_H__
#define __BOOT_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "type.h"
#include "ald_usart.h"


/** @addtogroup Bootloader
  * @{
  */
/** @addtogroup Base
  * @{
  */
/** @defgroup Base_Public_Macros Public Macros
  * @{
  */
#define BOOT_ES32H0

#define RUN_FROM_FLASH      0x0
#define RUN_FROM_SRAM       0x1
#define RUN_MODE_DEFAULT    RUN_FROM_FLASH
/**
  * @}
  */

/** @defgroup Base_Public_Types Public Types
  * @{
  */
typedef void (*timer_cbk)(void);

/**
  * @brief Timer environment variable
  */
typedef struct
{
    uint32_t tick;      /**< Timeout in milliseconds */
    uint32_t state;     /**< Status */
    uint32_t timeout;   /**< Indicates whether timeout */
    timer_cbk cbk;      /**< Callback function */
} timer_env_t;
/**
  * @}
  */

/** @addtogroup Base_Public_Functions
  * @{
  */
extern void boot_enter(usart_handle_t *hperh);
/**
  * @}
  */

/**
  * @}
  */
/**
  * @}
  */
#ifdef __cplusplus
extern "C"
}
#endif
#endif
