/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    22 Feb 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          22 Feb  2023    shicc           version:1.0.1
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


/* Includes ----------------------------------------------------------------- */

#include <string.h>
#include "main.h"

/* Public Variables ---------------------------------------------------------- */
uint32_t  len_hex;

/* Public Function ---------------------------------------------------------- */


/* Private Macros ------------------------------------------------------------ */


/* Private Variables--------------------------------------------------------- */

static md_uart_init_t s_uart_init;
/* Private Constants --------------------------------------------------------- */


/* Private function prototypes ----------------------------------------------- */


/* Private Function ---------------------------------------------------------- */
/**
  * @brief  init pins used fot uart communication.
  * @param  None
  * @retval None
  */
void uart0_pins_init(void)
{
    md_gpio_init_t gpio_config;

    /* Initialize tx pin */
    gpio_config.mode  = MD_GPIO_MODE_OUTPUT;
    gpio_config.odos  = MD_GPIO_PUSH_PULL;
    gpio_config.pupd  = MD_GPIO_PUSH_UP;
    gpio_config.podrv = MD_GPIO_OUT_DRIVE_1;
    gpio_config.nodrv = MD_GPIO_OUT_DRIVE_1;
    gpio_config.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_config.type  = MD_GPIO_TYPE_TTL;
    gpio_config.func  = MD_GPIO_FUNC_4;
    md_gpio_init(GPIOA, MD_GPIO_PIN_13, &gpio_config);

    /* Initialize rx pin */
    gpio_config.mode  = MD_GPIO_MODE_INPUT;
    gpio_config.odos  = MD_GPIO_PUSH_PULL;
    gpio_config.pupd  = MD_GPIO_PUSH_UP;
    gpio_config.podrv = MD_GPIO_OUT_DRIVE_1;
    gpio_config.nodrv = MD_GPIO_OUT_DRIVE_1;
    gpio_config.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_config.type  = MD_GPIO_TYPE_TTL;
    gpio_config.func  = MD_GPIO_FUNC_4;
    md_gpio_init(GPIOA, MD_GPIO_PIN_14, &gpio_config);
    return;
}


/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    /* Configure system clock */
    md_cmu_pll_config(MD_CMU_PLL_INPUT_HRC_6, MD_CMU_PLL_OUTPUT_48M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL, 48000000);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();

    /* Init communication parameters */
    uart0_pins_init();
    md_uart_init_struct(&s_uart_init);
    s_uart_init.parity = MD_UART_PARITY_EVEN;
    md_uart_init(COMMUNICATION_TYPE, &s_uart_init);

    /* Config uart0 interrupt */
    NVIC_SetPriority(UART0_IRQn, 0x01);
    NVIC_EnableIRQ(UART0_IRQn);

    md_uart_set_abrmod(COMMUNICATION_TYPE, 1);
    md_uart_enable_abr(COMMUNICATION_TYPE);

    md_uart_set_tx_threshold(COMMUNICATION_TYPE, MD_UART_TXFIFO_EMPTY);
    md_uart_set_rx_threshold(COMMUNICATION_TYPE, MD_UART_RXFIFO_1BYTE);

    md_uart_enable_it_rfth(COMMUNICATION_TYPE);

    /* Init state machine */
    fsm_comm_func_init();
    fsm_exec_func_init();
    fsm_para_init();

#ifdef __USE_CRC32
    /* Determine whether the length is valid */
    len_hex = *((uint32_t *)CRC_CAL_ADDR + 1);

    if (len_hex <= CRC_CAL_ADDR - APP_ADDR)
    {
        /* If the verification is valid, jump to app */
        if (verify_valid() == PASS)
        {
            g_isp_data.p_go(GO_APP);
        }
    }

#else
    g_isp_data.p_go(GO_APP);
#endif

    while (1)
    {
        while (fsm_is_trigger())
        {
            proc_fsm();
        }
    }
}

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
