/**********************************************************************************
 *
 * @file    irq.c
 * @brief   Interrupt handler
 *
 * @date    19 Jun. 2025
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          19 Jun. 2025    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */


/**
  * @brief  UART IRQ handler
  * @retval None
  */
void UART1_IRQHandler(void)
{
    if (md_uart_mask_it_linbk(LIN_NODE))
    {
        /* Clear lin break interrupt flag */
        md_uart_clear_flag_linbk(LIN_NODE);
        /* clear interrupt flag of rx byte format error */
        md_uart_clear_flag_rxberr(LIN_NODE);

        /* Change frame stage to sync_stage */
        lin_break_seg_proc(&g_node1);
        md_uart_recv_data8(LIN_NODE);
    }

    if (md_uart_mask_it_rfnempty(LIN_NODE))
    {
        md_uart_clear_flag_rfnempty(LIN_NODE);

        while (md_uart_is_active_flag_rfnempty(LIN_NODE))
        {
            lin_recv_data_proc(&g_node1, md_uart_recv_data8(LIN_NODE));
        }
    }

    return;
}

/**
  * @brief  EXTI handler
  * @retval None
  */
void EXTI_2to3_IRQHandler(void)
{
    if (md_exti_get_ifm(EXTI, EXTI_PIN_1))
    {
        md_exti_set_icr(EXTI, EXTI_PIN_1);                   /* clear exit interrupt flag */

        g_node1.dir = L_READ;
        memcpy(g_node1.trans_buf, g_tx_buf, 8);
    }

    if (md_exti_get_ifm(EXTI, EXTI_PIN_2))
    {
        md_exti_set_icr(EXTI, EXTI_PIN_2);                   /* clear exit interrupt flag */

        g_node1.dir = L_WRITE;
    }

    return;
}

/**
  * @}
  */

/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
