/**********************************************************************************
 *
 * @file    main.h
 * @brief   header file of main.c
 *
 * @date    5 Jan. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          5 Jan. 2023     Biyq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __MAIN_H__
#define   __MAIN_H__
/* Includes ------------------------------------------------------------------ */
#include <stdio.h>
#include <string.h>
#include "md_conf.h"
#include "lin.h"

/* Exported Macros ----------------------------------------------------------- */
#define LIN_NODE        UART1
#define LIN_TX_PORT     GPIOC
#define LIN_TX_PIN      MD_GPIO_PIN_1
#define LIN_RX_PORT     GPIOC
#define LIN_RX_PIN      MD_GPIO_PIN_0
#define LIN_INH_PORT    GPIOA
#define LIN_INH_PIN     MD_GPIO_PIN_6
#define LIN_SLP_PORT    GPIOA
#define LIN_SLP_PIN     MD_GPIO_PIN_7

#define EXTI_PORT       GPIOA
#define EXTI_PIN_1      MD_GPIO_PIN_2
#define EXTI_PIN_2      MD_GPIO_PIN_3

/* Exported Types ------------------------------------------------------------ */
/* Exported Variables -------------------------------------------------------- */
extern lin_node_t g_node1;
extern uint8_t g_tx_buf[8];
extern uint8_t g_rx_buf[8];
extern uint8_t g_master_read;
extern uint8_t g_master_write;

/* Exported Constants -------------------------------------------------------- */
/* Exported Functions -------------------------------------------------------- */


#endif  /* __MAIN_H__ */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
