/**********************************************************************************
 *
 * @file    smart_card.h
 * @brief   smart_card h File.
 *
 * @date    09 July 2024
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          09 July 2024     Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/** @addtogroup USART_Application
  * @{
  */

/** @defgroup Smart_card Smart_card
  * @brief usart application demo for smart card
  * @{
  */

#ifndef _SMART_CARD_
#define _SMART_CARD_

/* Includes ------------------------------------------------------------------ */

#include <string.h>
#include "md_gpio.h"
#include "md_uart.h"
#include "md_rcu.h"

/* Exported Types ------------------------------------------------------------ */

/* Exported Macros ----------------------------------------------------------- */

#define CARD_OK     0x00
#define CARD_ERROR  0x01

#define CARD_IO_PORT    GPIOC
#define CARD_IO_PIN     MD_GPIO_PIN_1
#define CARD_RST_PORT   GPIOA
#define CARD_RST_PIN    MD_GPIO_PIN_13
#define CARD_CLK_PORT   GPIOC
#define CARD_CLK_PIN    MD_GPIO_PIN_2

#define CARD_RST_L      md_gpio_set_pin_low(CARD_RST_PORT, CARD_RST_PIN)
#define CARD_RST_H      md_gpio_set_pin_high(CARD_RST_PORT, CARD_RST_PIN)

/* Exported Variables -------------------------------------------------------- */

extern uint8_t g_tx_buf[32];
extern uint8_t g_tx_len;
extern uint8_t g_tx_i;
extern uint8_t g_rx_buf[32];
extern uint8_t g_rx_len;
extern uint8_t g_rx_i;

/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */

uint8_t reset_rec(uint8_t *rxbuf);
uint8_t instruction_test(void);
uint8_t rand_instruction_test(void);
uint8_t name_instruction_test(void);

#endif /*_SMART_CARD_*/
/**
  * @}Smart_card
  */

/**
  * @}Micro_Driver
  */
/******************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
