/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    08 July 2024
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          08 July 2024    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

char g_tx0_buf[256] = "UART2 : ";
char g_tx1_buf[256] = "UART1 : ";
uint32_t g_tx0_len ;
uint32_t g_tx0_i = 0U;
uint32_t g_tx1_len ;
uint32_t g_tx1_i = 0U;

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  Init UART pin
  * @retval None
  */
void uart_pin_init(void)
{
    md_gpio_init_t gpio_init;
    md_gpio_init_struct(&gpio_init);

    /* Initialize UART1 TX pin */
    gpio_init.mode  = MD_GPIO_MODE_FUNCTION;
    gpio_init.odos  = MD_GPIO_OPEN_DRAIN;
    gpio_init.pupd  = MD_GPIO_PUSH_UP;
    gpio_init.odrv  = MD_GPIO_DRIVING_8MA;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.func  = MD_GPIO_FUNC_3;
    md_gpio_init(UART1_TX_PORT, UART1_TX_PIN, &gpio_init);

    /* Initialize UART1 RX pin */
    gpio_init.mode  = MD_GPIO_MODE_FUNCTION;
    gpio_init.odos  = MD_GPIO_OPEN_DRAIN;
    gpio_init.pupd  = MD_GPIO_PUSH_UP;
    gpio_init.odrv  = MD_GPIO_DRIVING_8MA;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.func  = MD_GPIO_FUNC_3;
    md_gpio_init(UART1_RX_PORT, UART1_RX_PIN, &gpio_init);

    /* Initialize UART2 TX pin */
    gpio_init.mode  = MD_GPIO_MODE_FUNCTION;
    gpio_init.odos  = MD_GPIO_OPEN_DRAIN;
    gpio_init.pupd  = MD_GPIO_PUSH_UP;
    gpio_init.odrv  = MD_GPIO_DRIVING_8MA;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.func  = MD_GPIO_FUNC_3;
    md_gpio_init(UART2_TX_PORT, UART2_TX_PIN, &gpio_init);

    /* Initialize UART2 RX pin */
    gpio_init.mode  = MD_GPIO_MODE_FUNCTION;
    gpio_init.odos  = MD_GPIO_OPEN_DRAIN;
    gpio_init.pupd  = MD_GPIO_PUSH_UP;
    gpio_init.odrv  = MD_GPIO_DRIVING_8MA;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.func  = MD_GPIO_FUNC_3;
    md_gpio_init(UART2_RX_PORT, UART2_RX_PIN, &gpio_init);
}

/**
  * @brief:  Initialize the uart.
  * @param:  None
  * @retval: None
  */
void init_uart(void)
{
    md_uart_init_t uart_init;
    md_uart_init_struct(&uart_init);

    /* Initialize UART */
    uart_init.baud        = 115200;
    uart_init.word_length = MD_UART_WORD_LENGTH_8B;
    uart_init.stop_bits   = MD_UART_STOP_BITS_1;
    uart_init.parity      = MD_UART_PARITY_NONE;
    uart_init.fctl        = MD_UART_FLOW_CTL_DISABLE;
    uart_init.mode        = MD_UART_MODE_RS485;
    md_uart_init(UART1, &uart_init);
    md_uart_init(UART2, &uart_init);

    md_uart_set_rs485_addr(UART1, 0x1);
    md_uart_set_rs485_addr(UART2, 0xF);

    md_uart_enable_it_rfnempty(UART1);
    md_uart_enable_it_rfnempty(UART2);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    __disable_irq();

    md_rcu_pll_config(MD_RCU_PLLSRC_HRC, MD_RCU_PLLCLK_72M);
    md_rcu_clock_config(MD_RCU_SW_SYSCLK_PLL, 72000000U);

    md_mcu_irq_config(UART1_IRQn, 2, ENABLE);
    md_mcu_irq_config(UART2_IRQn, 2, ENABLE);
    __enable_irq();

    md_tick_init(MD_SYSTICK_CLKSRC_HCLK);
    md_init_1ms_tick();

    md_rcu_enable_gpioc(RCU);
    md_rcu_enable_uart1(RCU);
    md_rcu_enable_uart2(RCU);

    g_tx0_len = strlen(g_tx0_buf);
    g_tx1_len = strlen(g_tx1_buf);

    uart_pin_init();

    init_uart();

    while (1);
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
