/**********************************************************************************
 *
 * @file    irq.c
 * @brief   Interrupt C file
 *
 * @date    08 July 2024
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          08 July 2024    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#define isr_GLOBALS

/* Includes ------------------------------------------------------------------ */

#include "main.h"

/** @addtogroup Projects_Examples
  * @{
  */

/** @addtogroup INTERRUPT
  * @{
  */

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

uint8_t g_rx0_buf[256];
uint32_t g_rx0_len = sizeof(g_rx0_buf);
uint32_t g_rx0_i = 0U;
uint8_t g_first_0 = 0U;

uint8_t g_rx1_buf[256];
uint32_t g_rx1_len = sizeof(g_rx1_buf);
uint32_t g_rx1_i = 0U;
uint8_t g_first_1 = 0U;

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/** @addtogroup Exceptions Handlers
  * @{
  */

/******************************************************************/
/*                Core Processor Exceptions Handlers           */
/******************************************************************/

void NMI_Handler(void)
{
}

void HardFault_Handler(void)
{
    while (1);

}

void SVCall_Handler(void)
{
}

void PendSV_Handler(void)
{
}

void SysTick_Handler(void)
{
    md_inc_tick();

    return;
}

/******************************************************************/
/*              External Processor Exceptions Handlers            */
/******************************************************************/


void CMP_IRQHandler(void)                       /*  IRQ 31  */
{
    while (1);
}


void BS16T1_IRQHandler(void)                    /*  IRQ 30  */
{
    while (1);
}

void AD16C6T2_IRQHandler(void)                  /*  IRQ 29  */
{
    while (1);
}

void UART2_IRQHandler(void)                     /*  IRQ 28 */
{
    if (md_uart_mask_it_tfempty(UART2))
    {
        if (g_tx0_i < g_tx0_len + g_rx0_i + 1)
        {
            md_uart_set_send_data8(UART2, g_tx0_buf[g_tx0_i]);
            md_uart_clear_it_tfempty(UART2);

            g_tx0_i++;
        }
        else
        {
            g_tx0_i = 0;
            g_rx0_i = 0;
            md_uart_disable_it_tfempty(UART2);
        }
    }

    if (md_uart_mask_it_rfnempty(UART2))
    {
        if (g_first_0 == 0)
        {
            g_rx0_buf[g_rx0_i] = md_uart_recv_data8(UART2);
            md_uart_clear_flag_rfnempty(UART2);

            g_first_0++;
        }
        else
        {
            g_rx0_buf[g_rx0_i] = md_uart_recv_data8(UART2);
            md_uart_clear_flag_rfnempty(UART2);

            if ((g_rx0_i >= 1) && (g_rx0_buf[g_rx0_i - 1] == 0x0D) && (g_rx0_buf[g_rx0_i] == 0x0A))
            {
                memcpy(g_tx0_buf + g_tx0_len, g_rx0_buf, g_rx0_i + 1);
                md_uart_enable_it_tfempty(UART2);
                g_first_0 = 0;
            }
            else
            {
                g_rx0_i++;
            }

            if (g_rx0_i >= g_rx0_len)
                g_rx0_i = 0;
        }
    }

    return;
}

void UART1_IRQHandler(void)                        /*  IRQ 27 */
{
    if (md_uart_mask_it_tfempty(UART1))
    {
        if (g_tx1_i < g_tx1_len + g_rx1_i + 1)
        {
            md_uart_set_send_data8(UART1, g_tx1_buf[g_tx1_i]);
            md_uart_clear_it_tfempty(UART1);

            g_tx1_i++;
        }
        else
        {
            g_tx1_i = 0;
            g_rx1_i = 0;
            md_uart_disable_it_tfempty(UART1);
        }
    }

    if (md_uart_mask_it_rfnempty(UART1))
    {
        if (g_first_1 == 0)
        {
            g_rx1_buf[g_rx1_i] = md_uart_recv_data8(UART1);
            md_uart_clear_flag_rfnempty(UART1);

            g_first_1++;
        }
        else
        {
            g_rx1_buf[g_rx1_i] = md_uart_recv_data8(UART1);
            md_uart_clear_flag_rfnempty(UART1);

            if ((g_rx1_i >= 1) && (g_rx1_buf[g_rx1_i - 1] == 0x0D) && (g_rx1_buf[g_rx1_i] == 0x0A))
            {
                memcpy(g_tx1_buf + g_tx1_len, g_rx1_buf, g_rx1_i + 1);
                md_uart_enable_it_tfempty(UART1);
                g_first_1 = 0;
            }
            else
            {
                g_rx1_i++;
            }

            if (g_rx1_i >= g_rx1_len)
                g_rx1_i = 0;
        }
    }

    return;
}

void SPI1_IRQHandler(void)                      /*  IRQ 26 */
{
    while (1);
}

void I2C1_IRQHandler(void)                      /*  IRQ 25  */
{
    while (1);
}

void GP32C4T2_IRQHandler(void)                  /*  IRQ 24  */
{
    while (1);
}

void GP32C4T1_IRQHandler(void)                  /*  IRQ 23  */
{
    while (1);
}

void GP16C2T2_IRQHandler(void)                  /*  IRQ 22  */
{
    while (1);
}

void GP16C2T1_IRQHandler(void)                  /*  IRQ 21  */
{
    while (1);
}

void AD16C6T1_IRQHandler(void)                  /*  IRQ 20  */
{
    while (1);
}

void CAN1_IRQHandler(void)                      /*  IRQ 19  */
{
    while (1);
}

void CAN1_RXFIFO1_IRQHandler(void)              /*  IRQ 18  */
{
    while (1);
}

void CAN1_RXFIFO0_IRQHandler(void)              /*  IRQ 17  */
{
    while (1);
}

void CAN1_TX_IRQHandler(void)                   /*  IRQ 16  */
{
    while (1);
}

void SVA_IRQHandler(void)                       /*  IRQ 15  */
{
    while (1);
}

void ADC_IRQHandler(void)                       /*  IRQ 14  */
{
    while (1);
}

void DMA1_CH5_IRQHandler(void)                  /*  IRQ 13  */
{
    while (1);
}

void DMA1_CH4_IRQHandler(void)                  /*  IRQ 12  */
{
    while (1);
}

void DMA1_CH3_IRQHandler(void)                  /*  IRQ 11  */
{
    while (1);
}

void DMA1_CH2_IRQHandler(void)                  /*  IRQ 10  */
{
    while (1);
}

void DMA1_CH1_IRQHandler(void)                  /*  IRQ 9   */
{
    while (1);
}

void DMA1_CH0_IRQHandler(void)                  /*  IRQ 8   */
{
    while (1);
}

void EXTI_4to15_IRQHandler(void)                /*  IRQ 7   */
{
    while (1);
}

void EXTI_2to3_IRQHandler(void)                 /*  IRQ 6   */
{
    while (1);
}

void EXTI_0to1_IRQHandler(void)                 /*  IRQ 5   */
{
    while (1);
}

void RCU_IRQHandler(void)                       /*  IRQ 4    */
{
    while (1);
}

void WAKEUP_IRQHandler(void)                    /*  IRQ 3    */
{
    while (1);
}

void CM0IKMCU_IRQ2_IRQHandler(void)             /*  IRQ 2    */
{
    while (1);
}

void LVD_IRQHandler(void)                       /*  IRQ 1    */
{
    while (1);
}

void WWDT_IRQHandler(void)                      /*  IRQ 0    */
{
    while (1);
}

/**
  * @} Exceptions Handlers
  */

/**
  * @} INTERRUPT
  */

/**
  * @} Projects_Examples
  */
/******************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
