/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    26 July 2024
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          26 July 2024    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Initialize IO
  * @param  None
  * @retval None
  */
void init_gpio(void)
{
    md_gpio_init_t gpio_init;

    md_gpio_init_struct(&gpio_init);
    gpio_init.mode = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos = MD_GPIO_PUSH_PULL;
    gpio_init.pupd = MD_GPIO_FLOATING;
    gpio_init.odrv = MD_GPIO_DRIVING_8MA;
    gpio_init.flt  = MD_GPIO_FILTER_DISABLE;
    gpio_init.type = MD_GPIO_TYPE_CMOS;
    gpio_init.func = MD_GPIO_FUNC_0;
    md_gpio_init(TOGGLE_PORT, TOGGLE_PIN, &gpio_init);
    md_gpio_set_pin_low(TOGGLE_PORT, TOGGLE_PIN);

    md_gpio_init_struct(&gpio_init);
    gpio_init.mode = MD_GPIO_MODE_FUNCTION;
    gpio_init.odos = MD_GPIO_PUSH_PULL;
    gpio_init.pupd = MD_GPIO_FLOATING;
    gpio_init.odrv = MD_GPIO_DRIVING_8MA;
    gpio_init.flt  = MD_GPIO_FILTER_DISABLE;
    gpio_init.type = MD_GPIO_TYPE_CMOS;
    gpio_init.func = MD_GPIO_FUNC_5;
    md_gpio_init(ET_PORT, ET_PIN, &gpio_init);
}

/**
  * @brief:  Initialize AD16C6T
  * @param:  None
  * @retval: None
  */
static void init_timer(void)
{
    md_timer_base_init_t ad16c6t_init;

    md_timer_base_struct_init(&ad16c6t_init);        /* initialize the ad16c6t_init  */
    ad16c6t_init.prescaler = 1 - 1;                  /* clk_count: no prescaler */
    ad16c6t_init.clk_div = MD_TIMER_CLOCK_DIV1;      /* working clock of dead time and filter */
    ad16c6t_init.mode = MD_TIMER_CNT_MODE_UP;        /* count up */
    ad16c6t_init.period = 100 - 1;                   /* period is 100 count clock */
    ad16c6t_init.re_cnt = 1 - 1;                     /* 0 repeat count */
    md_timer_base_set_config(AD16C6T1, &ad16c6t_init);

    md_timer_enable_external_clk2mode_ecm2en(AD16C6T1); /* enable external clock2 mode */
    md_timer_set_external_trigger_prescaler_etpres(AD16C6T1, MD_TIMER_ETRPRESCALER_DISABLE); /* Prescaler OFF */
    md_timer_set_external_trigger_polarity_etpol(AD16C6T1, MD_TIMER_ETRPOLARITY_NONINVERTED); /* active at rising edge */
    md_timer_set_external_trigger_filter_etflt(AD16C6T1, MD_TIMER_ETRFILTER_FDIV1); /* No filter */

    md_timer_enable_it_upd(AD16C6T1);    /* enable updata interrupt */

    /* enable AD16C6T1 */
    md_timer_enable_counter_cnten(AD16C6T1);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    __disable_irq();

    md_rcu_pll_config(MD_RCU_PLLSRC_HRC, MD_RCU_PLLCLK_72M);
    md_rcu_clock_config(MD_RCU_SW_SYSCLK_PLL, 72000000U);

    /* Initialize SysTick Interrupt */
    md_tick_init(MD_SYSTICK_CLKSRC_HCLK);
    md_init_1ms_tick();

    md_mcu_irq_config(AD16C6T1_IRQn, 3, ENABLE);
    __enable_irq();

    md_rcu_enable_gpioa(RCU);
    md_rcu_enable_ad16c6t1(RCU);

    /* Initialize pin */
    init_gpio();
    /* Initialize timer */
    init_timer();

    while (1);
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
