/**********************************************************************************
 *
 * @file    uart.c
 * @brief   Main file for DEMO
 *
 * @date    15 July 2024
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          15 July 2024    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include <stdio.h>
#include "uart.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

static md_uart_init_t s_uart;

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

static void uart_pin_init(void);

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  uart function
  * @retval None.
  */
void mcu_uart_init(void)
{
    uart_pin_init();

    md_uart_init_struct(&s_uart);
    s_uart.mode        = MD_UART_MODE;
    s_uart.baud        = 115200;
    s_uart.word_length = MD_UART_WORD_LENGTH_8B;
    s_uart.stop_bits   = MD_UART_STOP_BITS_1;
    s_uart.parity      = MD_UART_PARITY_NONE;
    s_uart.fctl        = MD_UART_FLOW_CTL_DISABLE;
    md_uart_init(UART1, &s_uart);
}

/**
  * @brief  uart pin function
  * @retval None.
  */
static void uart_pin_init(void)
{
    md_gpio_init_t gpio_init;
    md_gpio_init_struct(&gpio_init);

    /* Initialize tx pin */
    gpio_init.mode  = MD_GPIO_MODE_FUNCTION;
    gpio_init.odos  = MD_GPIO_PUSH_PULL;
    gpio_init.pupd  = MD_GPIO_PUSH_UP;
    gpio_init.odrv  = MD_GPIO_DRIVING_8MA;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.func  = MD_GPIO_FUNC_3;
    md_gpio_init(GPIOC, MD_GPIO_PIN_1, &gpio_init);
}

int fputc(int c, FILE *f)
{
    while (!(UART1->STAT & MD_UART_STATUS_TFEMPTY));

    UART1->TXBUF = (uint8_t)c;

    return c;
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
