/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    15 July 2024
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          15 July 2024    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */

#include "main.h"

/* Private Variables --------------------------------------------------------- */

/* Length must be less than one page (256 bytes) */
static char s_flash_txbuf[32] = "essemi mcu spi flash example!";
static char s_flash_rxbuf[32];

/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Macros ------------------------------------------------------------ */

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples_SPI
  * @{
  */
/* Public Variables ---------------------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    uint32_t id;
    md_status_t status;

    __disable_irq();

    md_rcu_pll_config(MD_RCU_PLLSRC_HRC, MD_RCU_PLLCLK_72M);
    md_rcu_clock_config(MD_RCU_SW_SYSCLK_PLL, 72000000U);

    /* Initialize SysTick Interrupt */
    md_tick_init(MD_SYSTICK_CLKSRC_HCLK);
    md_init_1ms_tick();

    __enable_irq();

    md_rcu_enable_gpioa(RCU);
    md_rcu_enable_gpioc(RCU);
    md_rcu_enable_uart1(RCU);
    md_rcu_enable_spi1(RCU);

    mcu_uart_init();    /* To initialize the UART module */
    mcu_spi_init();     /* Initialize the SPI module */

    id = flash_read_id();
    printf("\r\nManufacturer ID is %02x & Device ID is %02x %02x\r\n", (uint8_t)(id >> 16), (uint8_t)(id >> 8), (uint8_t)id);

    printf("Now erase the sector containing address 0...\r\n");
    status = flash_sector_erase(0);

    if (status == MD_OK)
    {
        flash_wait_unbusy();    /* Waiting for erasing */
        printf("Erase OK!\r\n");
    }

    printf("The date written to flash is -> %s\r\n", s_flash_txbuf);
    status = flash_write(0, s_flash_txbuf, strlen(s_flash_txbuf) + 1);

    if (status == MD_OK)
    {
        flash_wait_unbusy();    /*Waiting for the written to complete*/
        printf("Write OK!\r\n");
    }

    status = flash_read(0, s_flash_rxbuf, strlen(s_flash_txbuf) + 1);   /*Read write data*/
    printf("The data read from flash is  -> %s\r\n", s_flash_rxbuf);

    if (!memcmp(s_flash_txbuf, s_flash_rxbuf, strlen(s_flash_txbuf) + 1))   /*Data is written and read*/
        printf("Read OK!\r\n");
    else
        printf("Read ERROR!\r\n");

    while(1);
}

/**
  * @} Examples_SPI
  */

/**
  * @} Projects_Examples_MD
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
