/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    22 Apr. 2024
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          22 Apr. 2024    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include "main.h"

/* Private Variables --------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Macros ------------------------------------------------------------ */

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples_SPI
  * @{
  */
/* Public Variables ---------------------------------------------------------- */
uint8_t g_send_buf[20] = {0U};
uint8_t g_recv_buf[20] = {0U};
uint8_t g_send_len = sizeof(g_send_buf);
uint8_t g_recv_len = sizeof(g_recv_buf);
uint8_t g_send_ind = 0U;
uint8_t g_recv_ind = 0U;

md_spi_init_t g_spi_config;

/* Private Function ---------------------------------------------------------- */

/*Host mode communication pins initialization function*/
void spi_pin_init(void)
{
    md_gpio_init_t gpio_init;

    /* Host SCK pin initialization, configuration for the output mode */
    gpio_init.mode = MD_GPIO_MODE_FUNCTION;
    gpio_init.odos = MD_GPIO_PUSH_PULL;
    gpio_init.pupd = MD_GPIO_PUSH_UP;
    gpio_init.odrv = MD_GPIO_DRIVING_16MA;
    gpio_init.flt  = MD_GPIO_FILTER_DISABLE;
    gpio_init.type = MD_GPIO_TYPE_CMOS;
    gpio_init.func = MD_GPIO_FUNC_2;
    md_gpio_init(SPI_SCK_PORT, SPI_SCK_PIN, &gpio_init);

    /* Host MISO pins initialization, configuration for the input mode */
    gpio_init.mode = MD_GPIO_MODE_FUNCTION;
    gpio_init.odos = MD_GPIO_PUSH_PULL;
    gpio_init.pupd = MD_GPIO_PUSH_UP;
    gpio_init.odrv = MD_GPIO_DRIVING_16MA;
    gpio_init.flt  = MD_GPIO_FILTER_DISABLE;
    gpio_init.type = MD_GPIO_TYPE_CMOS;
    gpio_init.func = MD_GPIO_FUNC_2;
    md_gpio_init(SPI_MISO_PORT, SPI_MISO_PIN, &gpio_init);

    /* Host MOSI pin initialization, configuration for the output mode */
    gpio_init.mode = MD_GPIO_MODE_FUNCTION;
    gpio_init.odos = MD_GPIO_PUSH_PULL;
    gpio_init.pupd = MD_GPIO_PUSH_UP;
    gpio_init.odrv = MD_GPIO_DRIVING_16MA;
    gpio_init.flt  = MD_GPIO_FILTER_DISABLE;
    gpio_init.type = MD_GPIO_TYPE_CMOS;
    gpio_init.func = MD_GPIO_FUNC_2;
    md_gpio_init(SPI_MOSI_PORT, SPI_MOSI_PIN, &gpio_init);

    /* Host NSS pin initialization, configuration for the output mode */
    gpio_init.mode = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos = MD_GPIO_PUSH_PULL;
    gpio_init.pupd = MD_GPIO_PUSH_UP;
    gpio_init.odrv = MD_GPIO_DRIVING_16MA;
    gpio_init.flt  = MD_GPIO_FILTER_DISABLE;
    gpio_init.type = MD_GPIO_TYPE_CMOS;
    gpio_init.func = MD_GPIO_FUNC_0;        /* GPIO */
    md_gpio_init(SPI_NSS_PORT, SPI_NSS_PIN, &gpio_init);
    md_gpio_set_pin_high(SPI_NSS_PORT, SPI_NSS_PIN);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    uint16_t cnt;

    __disable_irq();

    md_rcu_pll_config(MD_RCU_PLLSRC_HRC, MD_RCU_PLLCLK_72M);
    md_rcu_clock_config(MD_RCU_SW_SYSCLK_PLL, 72000000U);

    /* Initialize SysTick Interrupt */
    md_tick_init(MD_SYSTICK_CLKSRC_HCLK);
    md_init_1ms_tick();

    md_mcu_irq_config(SPI1_IRQn, 3, ENABLE);
    __enable_irq();

    md_rcu_enable_gpioa(RCU);
    md_rcu_enable_spi1(RCU);

    spi_pin_init();

    md_spi_struct_init(&g_spi_config);
    g_spi_config.SPIx      = SPI1;
    g_spi_config.mode      = MD_SPI_MODE_MASTER;
    g_spi_config.dir       = MD_SPI_DIRECTION_2LINES;
    g_spi_config.data_size = MD_SPI_DATA_SIZE_8;
    g_spi_config.baud      = MD_SPI_BAUD_256;
    g_spi_config.phase     = MD_SPI_CPHA_SECOND;
    g_spi_config.polarity  = MD_SPI_CPOL_HIGH;
    g_spi_config.first_bit = MD_SPI_FIRSTBIT_MSB;
    g_spi_config.ss_en     = DISABLE;
    g_spi_config.crc_calc  = DISABLE;
    g_spi_config.crc_poly  = 0;
    md_spi_init(&g_spi_config);
    md_spi_enable_it_rxne(SPI1);

    while (1)
    {
        memcpy(g_send_buf, g_recv_buf, g_recv_len);

        md_gpio_set_pin_low(SPI_NSS_PORT, SPI_NSS_PIN);

        md_spi_enable_it_txe(SPI1);

        cnt = 40000U;

        while (md_spi_is_enable_it_txe(SPI1) && (--cnt));

        cnt = 40000U;

        while ((g_recv_ind != 0) && (--cnt));

        md_gpio_set_pin_high(SPI_NSS_PORT, SPI_NSS_PIN);

        md_delay_1ms(1000);
    }
}

/**
  * @} Examples_SPI
  */

/**
  * @} Projects_Examples_MD
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
