/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    11 Apr. 2024
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          11 Apr. 2024    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
uint32_t g_sysclk;
uint32_t g_hclk;
uint32_t g_pclk;

/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */
/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  Initializate pin of MCO.
  * @retval None
  */
void md_mco_pin_init(void)
{
    md_gpio_init_t gpio_init;

    /* initialize the MCO */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode  = MD_GPIO_MODE_FUNCTION;
    gpio_init.odos  = MD_GPIO_PUSH_PULL;
    gpio_init.pupd  = MD_GPIO_FLOATING;
    gpio_init.odrv  = MD_GPIO_DRIVING_8MA;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.func  = MD_GPIO_FUNC_0;
    md_gpio_init(MCO_PORT, MCO_PIN, &gpio_init);

    return;
}

/**
  * @brief:  Main program.
  * @param:  None
  * @retval: None
  */
int main(void)
{
    __disable_irq();

    /* Configure system clock */
    md_rcu_pll_config(MD_RCU_PLLSRC_HRC, MD_RCU_PLLCLK_72M);
    md_rcu_clock_config(MD_RCU_SW_SYSCLK_PLL, 72000000U);

    md_rcu_set_hclk_div(RCU, MD_RCU_HPRE_SYSCLK_DIV_8);
    md_rcu_set_pclk_div(RCU, MD_RCU_PPRE_HCLK_DIV_16);

    md_rcu_set_mco_div(RCU, MD_RCU_MPRE_MCO_DIV128);
    md_rcu_set_mco_source(RCU, MD_RCU_MSW_MCO_PCLK);

    __enable_irq();

    md_rcu_enable_gpiob(RCU);

    /* Initialize pin */
    md_mco_pin_init();

    /* get current clock */
    g_sysclk = SystemFrequency_SysClk;
    g_hclk = SystemFrequency_AHBClk;
    g_pclk = SystemFrequency_APBClk;

    while (1)
    {

    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
