/**********************************************************************************
 *
 * @file    eeprom.c
 * @brief   SPI Flash file for DEMO
 *
 * @date    09 July 2024
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          09 July 2024    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include "eeprom.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

static md_i2c_init_t s_i2c;

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

static void i2c_pin_init(void);

/* Private Function ---------------------------------------------------------- */

/**
  * @brief i2c function
  * @retval None.
  */
void mcu_i2c_init(void)
{
    i2c_pin_init();

    md_i2c_struct_init(&s_i2c);
    s_i2c.module       = MD_I2C_MODULE_MASTER;
    s_i2c.clk_speed    = MD_I2C_EXTREME_FAST_MODE_MAX_CLK;
    s_i2c.own_addr1    = 0x2D << 1;
    s_i2c.addr_mode    = MD_I2C_ADDR_7BIT;
    s_i2c.general_call = MD_I2C_GENERALCALL_DISABLE;
    s_i2c.no_stretch   = MD_I2C_NOSTRETCH_DISABLE;
    md_i2c_init(I2C1, &s_i2c);  /* According to the initialization parameter I2C module */
}

/**
  * @brief  Initializate i2c pin
  * @retval None.
  */
static void i2c_pin_init(void)
{
    md_gpio_init_t l_gpio;

    l_gpio.type  = MD_GPIO_TYPE_CMOS;
    l_gpio.odos  = MD_GPIO_OPEN_DRAIN;
    l_gpio.pupd  = MD_GPIO_PUSH_UP;
    l_gpio.odrv  = MD_GPIO_DRIVING_8MA;
    l_gpio.flt   = MD_GPIO_FILTER_DISABLE;
    l_gpio.func  = MD_GPIO_FUNC_1;
    l_gpio.mode  = MD_GPIO_MODE_FUNCTION;
    md_gpio_init(GPIOC, MD_GPIO_PIN_10, &l_gpio);   /*Initialize PC10 for SCL pin*/
    md_gpio_init(GPIOC, MD_GPIO_PIN_11, &l_gpio);   /*Initialize PC11 for SDA pin*/
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
