/**********************************************************************************
 *
 * @file    md_conf.h
 * @brief   Enable/Disable the peripheral module.
 *
 * @date    09 July 2024
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          09 July 2024    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
#ifndef   __MD_CONF_H__
#define   __MD_CONF_H__

/* Includes ------------------------------------------------------------------ */

/* #define MD_ADC */
/* #define MD_CALC */
/* #define MD_CAN */
/* #define MD_CMP */
/* #define MD_DMA */
/* #define MD_EXTI */
/* #define MD_FC */
#define MD_GPIO
#define MD_I2C
/* #define MD_IIR */
/* #define MD_IWDT */
/* #define MD_OPAMP */
/* #define MD_PI */
#define MD_RCU
/* #define MD_SPI */
/* #define MD_SVA */
/* #define MD_SYSCFG */
#define MD_TICK
/* #define MD_TIMER */
#define MD_UART
#define MD_UTILS
/* #define MD_VRES */
/* #define MD_WWDT */

#ifdef MD_ADC
    #include "md_adc.h"
#endif /* MD_ADC */

#ifdef MD_CALC
    #include "md_calc.h"
#endif /* MD_CALC */

#ifdef MD_CAN
    #include "md_can.h"
#endif /* MD_CAN */

#ifdef MD_CMP
    #include "md_cmp.h"
#endif /* MD_CMP */

#ifdef MD_DMA
    #include "md_dma.h"
#endif /* MD_DMA */

#ifdef MD_EXTI
    #include "md_exti.h"
#endif /* MD_EXTI */

#ifdef MD_FC
    #include "md_fc.h"
#endif /* MD_FC */

#ifdef MD_GPIO
    #include "md_gpio.h"
#endif /* MD_GPIO */

#ifdef MD_I2C
    #include "md_i2c.h"
#endif /* MD_I2C */

#ifdef MD_IIR
    #include "md_iir.h"
#endif /* MD_IIR */

#ifdef MD_IWDT
    #include "md_iwdt.h"
#endif /* MD_IWDT */

#ifdef MD_OPAMP
    #include "md_opamp.h"
#endif /* MD_OPAMP */

#ifdef MD_PI
    #include "md_pi.h"
#endif /* MD_PI */

#ifdef MD_RCU
    #include "md_rcu.h"
#endif /* MD_RCU */

#ifdef MD_SPI
    #include "md_spi.h"
#endif /* MD_SPI */

#ifdef MD_SVA
    #include "md_sva.h"
#endif /* MD_SVA */

#ifdef MD_SYSCFG
    #include "md_syscfg.h"
#endif /* MD_SYSCFG */

#ifdef MD_TICK
    #include "md_tick.h"
#endif /* MD_TICK */

#ifdef MD_TIMER
    #include "md_timer.h"
#endif /* MD_TIMER */

#ifdef MD_UART
    #include "md_uart.h"
#endif /* MD_UART */

#ifdef MD_UTILS
    #include "md_utils.h"
#endif /* MD_UTILS */

#ifdef MD_VRES
    #include "md_vres.h"
#endif /* MD_VRES */

#ifdef MD_WWDT
    #include "md_wwdt.h"
#endif /* MD_WWDT */

/* Exported Types ------------------------------------------------------------ */
/* Exported Macros ----------------------------------------------------------- */
/* Exported Variables -------------------------------------------------------- */
/* Exported Constants -------------------------------------------------------- */
/* Exported Functions -------------------------------------------------------- */

#endif /*__MD_CONF_H__*/

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
