/**********************************************************************************
 *
 * @file    irq.c
 * @brief   Interrupt C file
 *
 * @date    09 July 2024
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          09 July 2024    Lisq           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#define isr_GLOBALS

/* Includes ------------------------------------------------------------------ */

#include "main.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/** @addtogroup Projects_Examples
  * @{
  */

/** @addtogroup INTERRUPT
  * @{
  */

/** @addtogroup Exceptions Handlers
  * @{
  */

/******************************************************************/
/*                Core Processor Exceptions Handlers           */
/******************************************************************/

void NMI_Handler(void)
{
}

void HardFault_Handler(void)
{
    while (1);

}

void SVCall_Handler(void)
{
}

void PendSV_Handler(void)
{
}

void SysTick_Handler(void)
{
    md_inc_tick();
    return;
}

/******************************************************************/
/*              External Processor Exceptions Handlers            */
/******************************************************************/


void CM0IKMCU_IRQ31_IRQHandler(void)            /*  IRQ 31  */
{
    while (1);
}


void UART4_IRQHandler(void)                     /*  IRQ 30  */
{
    while (1);
}

void UART3_IRQHandler(void)                     /*  IRQ 29  */
{
    while (1);
}

void UART2_IRQHandler(void)                     /*  IRQ 28 */
{
    while (1);
}

void UART1_IRQHandler(void)                     /*  IRQ 27 */
{
    while (1);
}

void CM0IKMCU_IRQ26_IRQHandler(void)            /*  IRQ 26 */
{
    while (1);
}

void SPI1_IRQHandler(void)                      /*  IRQ 25  */
{
    while (1);
}

void CM0IKMCU_IRQ24_IRQHandler(void)            /*  IRQ 24  */
{
    while (1);
}

void I2C1_IRQHandler(void)                      /*  IRQ 23  */
{
    /* if tx data is empty, send data */
    if (md_i2c_mask_it_txe(I2C1))
    {
        md_i2c_set_tx_reg_data(I2C1, g_send_buf[g_send_inc]);
        md_i2c_clear_flag_txe(I2C1);

        g_send_inc++;

        if (g_send_inc >= g_send_len)
        {
            md_i2c_disable_it_txe(I2C1);
            g_send_inc = 0;
        }
    }

    /* if rx data is not empty, transmit data */
    if (md_i2c_mask_it_rxne(I2C1))
    {
        g_recv_buf[g_recv_inc] = md_i2c_get_rx_reg_data(I2C1);
        md_i2c_clear_flag_rxne(I2C1);

        g_recv_inc++;

        if (g_recv_inc >= g_recv_len)
        {
            g_recv_inc = 0;
            memcpy(g_send_buf, g_recv_buf, g_recv_len);
        }
    }

    /* if a matching address is received */
    if (md_i2c_mask_it_addr(I2C1))
    {
        md_i2c_clear_flag_addr(I2C1);

        if (md_i2c_is_active_flag_read(I2C1))
            /* Enable TXE interrupt */
            md_i2c_enable_it_txe(I2C1);
        else
            /* Enable RXNE interrupt */
            md_i2c_enable_it_rxne(I2C1);
    }

    /* if a stop bit is received */
    if (md_i2c_mask_it_stop(I2C1))
    {
        md_i2c_clear_flag_stop(I2C1);

        /* Enable RXNE interrupt */
        md_i2c_disable_it_rxne(I2C1);

        g_send_inc = 0;
        g_recv_inc = 0;
    }

    if (md_i2c_mask_it_nack(I2C1))
    {
        md_i2c_clear_flag_nack(I2C1);

        md_i2c_disable_it_txe(I2C1);

        g_send_inc = 0;
        g_recv_inc = 0;
    }

    return;
}

void GP16C2T4_IRQHandler(void)                  /*  IRQ 22  */
{
    while (1);
}

void GP16C2T3_IRQHandler(void)                  /*  IRQ 21  */
{
    while (1);
}

void GP16C2T2_IRQHandler(void)                  /*  IRQ 20  */
{
    while (1);
}

void GP16C2T1_IRQHandler(void)                  /*  IRQ 19  */
{
    while (1);
}

void CM0IKMCU_IRQ18_IRQHandler(void)            /*  IRQ 18  */
{
    while (1);
}

void CM0IKMCU_IRQ17_IRQHandler(void)            /*  IRQ 17  */
{
    while (1);
}

void CM0IKMCU_IRQ16_IRQHandler(void)            /*  IRQ 16  */
{
    while (1);
}

void GP32C4T1_IRQHandler(void)                  /*  IRQ 15  */
{
    while (1);
}

void BS16T1_IRQHandler(void)                    /*  IRQ 14  */
{
    while (1);
}

void OPAMP_IRQHandler(void)                     /*  IRQ 13  */
{
    while (1);
}

void COMP_IRQHandler(void)                      /*  IRQ 12  */
{
    while (1);
}

void ADC_IRQHandler(void)                       /*  IRQ 11  */
{
    while (1);
}

void LCD_IRQHandler(void)                       /*  IRQ 10  */
{
    while (1);
}

void CM0IKMCU_IRQ9_IRQHandler(void)             /*  IRQ 9   */
{
    while (1);
}

void CM0IKMCU_IRQ8_IRQHandler(void)             /*  IRQ 8   */
{
    while (1);
}

void EXTI_4to15_IRQHandler(void)                /*  IRQ 7   */
{
    while (1);
}

void EXTI_2to3_IRQHandler(void)                 /*  IRQ 6   */
{
    while (1);
}

void EXTI_0to1_IRQHandler(void)                 /*  IRQ 5   */
{
    while (1);
}

void RCU_IRQHandler(void)                       /*  IRQ 4    */
{
    while (1);
}

void WAKEUP_IRQHandler(void)                    /*  IRQ 3    */
{
    while (1);
}

void RTC_IRQHandler(void)                       /*  IRQ 2    */
{
    while (1);
}

void LVD_IRQHandler(void)                       /*  IRQ 1    */
{
    while (1);
}

void WWDT_IRQHandler(void)                      /*  IRQ 0    */
{
    while (1);
}

/**
  * @} Exceptions Handlers
  */

/**
  * @} INTERRUPT
  */

/**
  * @} Projects_Examples
  */
/******************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
