/**********************************************************************************
 *
 * @file    main.h
 * @brief   Header file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __MAIN_H__
#define   __MAIN_H__

/* Includes ------------------------------------------------------------------ */
#include "md_conf.h"

/* Exported Types ------------------------------------------------------------ */

/* Exported Macros ----------------------------------------------------------- */

#define I2C1_SCL_PORT   GPIOC
#define I2C1_SCL_PIN    MD_GPIO_PIN_10      /* I2CSCL */
#define I2C1_SDA_PORT   GPIOC
#define I2C1_SDA_PIN    MD_GPIO_PIN_11      /* I2CSDA */

#define SLAVE_ADDR   0x2D

/* Exported Variables -------------------------------------------------------- */

extern md_i2c_init_t g_md_i2c;
extern uint8_t g_recv_buf[20];
extern uint8_t g_recv_len;
extern uint8_t g_recv_inc;
extern uint8_t g_send_buf[20];
extern uint8_t g_send_len;
extern uint8_t g_send_inc;
extern uint8_t g_complete;
extern uint8_t g_error_flag;

/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */

#endif   /*__MAIN_H__*/

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
