/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    09 Apr. 2024
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          09 Apr. 2024    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes -------------------------------------------------------------------*/

#include "main.h"

/* Private types --------------------------------------------------------------*/
/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */

/** @addtogroup Projects_Examples_MD
  * @{
  */

/**
  * @brief  Initializate pins.
  * @retval None
  */
static void init_gpio(void)
{
    md_gpio_init_t gpio_init;

    GPIOA->MOD = 0x55555555;
    GPIOA->BSBR = 0xFFFF0000;
    GPIOA->DS = 0xFFFF;
    GPIOB->MOD = 0x55555555;
    GPIOB->BSBR = 0xFFFF0000;
    GPIOB->DS = 0xFFFF;
    GPIOC->MOD = 0x55555555;
    GPIOC->BSBR = 0xFFFF0000;
    GPIOC->DS = 0xFFFF;

    /* Initialize LED pin */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode  = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos  = MD_GPIO_PUSH_PULL;
    gpio_init.pupd  = MD_GPIO_FLOATING;
    gpio_init.odrv  = MD_GPIO_DRIVING_16MA;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.func  = MD_GPIO_FUNC_0;
    md_gpio_init(LED1_PORT, LED1_PIN, &gpio_init);
    md_gpio_init(LED2_PORT, LED2_PIN, &gpio_init);
    md_gpio_set_pin_high(LED1_PORT, LED1_PIN);

    /* Initialize KEY pin */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode  = MD_GPIO_MODE_INPUT;
    gpio_init.odos  = MD_GPIO_PUSH_PULL;
    gpio_init.pupd  = MD_GPIO_PUSH_UP;
    gpio_init.odrv  = MD_GPIO_DRIVING_16MA;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.func  = MD_GPIO_FUNC_0;
    md_gpio_init(KEY_PORT, KEY_PIN, &gpio_init);

    return;
}

/**
  * @brief  main.
  * @param  None
  * @retval None
  */
int main(void)
{
    md_gpio_init_t gpio_init;

    __disable_irq();

    md_rcu_pll_config(MD_RCU_PLLSRC_HRC, MD_RCU_PLLCLK_48M);
    md_rcu_clock_config(MD_RCU_SW_SYSCLK_PLL, 48000000U);

    md_rcu_enable_gpioa(RCU);
    md_rcu_enable_gpiob(RCU);
    md_rcu_enable_gpioc(RCU);

    md_tick_init(MD_SYSTICK_CLKSRC_HCLK);
    md_init_1ms_tick();

    __enable_irq();

    /* Initialize pin */
    init_gpio();

    while(md_gpio_get_inputpinset(KEY_PORT, KEY_PIN));

    /* Initialize KEY pin */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode  = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos  = MD_GPIO_PUSH_PULL;
    gpio_init.pupd  = MD_GPIO_FLOATING;
    gpio_init.odrv  = MD_GPIO_DRIVING_16MA;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.type  = MD_GPIO_TYPE_TTL;
    gpio_init.func  = MD_GPIO_FUNC_0;
    md_gpio_init(KEY_PORT, KEY_PIN, &gpio_init);
    md_gpio_set_pin_low(KEY_PORT, KEY_PIN);

    while (1)
    {
        md_delay_1ms(500);
        md_gpio_set_pin_high(LED2_PORT, LED2_PIN);
        md_gpio_set_pin_low(LED1_PORT, LED1_PIN);
        md_delay_1ms(500);
        md_gpio_set_pin_high(LED1_PORT, LED1_PIN);
        md_gpio_set_pin_low(LED2_PORT, LED2_PIN);
    }
}

/**
  * @} Projects_Examples_MD
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/


