/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    01 July 2024
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          01 July 2024    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/** @addtogroup Projects_Examples_MD
  * @{
  */

/**
  * @brief  Init CMP1 pin
  * @retval None
  */
void cmp_pin_init(void)
{
    md_gpio_init_t gpio_init;
    md_gpio_init_struct(&gpio_init);

    /* Initialize CMP1_INP pin */
    gpio_init.mode  = MD_GPIO_MODE_ANALOG;
    gpio_init.odos  = MD_GPIO_PUSH_PULL;
    gpio_init.pupd  = MD_GPIO_FLOATING;
    gpio_init.odrv  = MD_GPIO_DRIVING_8MA;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.func  = MD_GPIO_FUNC_0;
    md_gpio_init(CMP1_INP_PORT, CMP1_INP_PIN, &gpio_init);

    /* Initialize CMP1_OUT pin */
    gpio_init.mode  = MD_GPIO_MODE_FUNCTION;
    gpio_init.odos  = MD_GPIO_PUSH_PULL;
    gpio_init.pupd  = MD_GPIO_PUSH_UP;
    gpio_init.odrv  = MD_GPIO_DRIVING_8MA;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.func  = MD_GPIO_FUNC_4;
    md_gpio_init(CMP1_OUT_PORT, CMP1_OUT_PIN, &gpio_init);

    /* Initialize LED1 pin */
    gpio_init.mode  = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos  = MD_GPIO_PUSH_PULL;
    gpio_init.pupd  = MD_GPIO_FLOATING;
    gpio_init.odrv  = MD_GPIO_DRIVING_8MA;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.func  = MD_GPIO_FUNC_0;
    md_gpio_init(LED1_PORT, LED1_PIN, &gpio_init);
    md_gpio_set_pin_high(LED1_PORT, LED1_PIN);

    /* Initialize LED2 pin */
    gpio_init.mode  = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos  = MD_GPIO_PUSH_PULL;
    gpio_init.pupd  = MD_GPIO_FLOATING;
    gpio_init.odrv  = MD_GPIO_DRIVING_8MA;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.func  = MD_GPIO_FUNC_0;
    md_gpio_init(LED2_PORT, LED2_PIN, &gpio_init);
    md_gpio_set_pin_high(LED2_PORT, LED2_PIN);
}

/**
  * @brief:  Initialize the CMP.
  * @param:  None
  * @retval: None
  */
void cmp_init(void)
{
    md_cmp1_enable(CMP);
    md_cmp1_set_blanking_source(CMP, MD_CMP_CFG_BLANKSEL_CLOSE);
    md_cmp1_disable_hysteresis(CMP);
    md_cmp1_disable_polarity(CMP);
    md_syscfg_enable_vdda(SYSCFG);
    md_syscfg_enable_adc_cmp_vref(SYSCFG);
    md_tick_wait100us(1, 1);
    md_cmp1_set_input_negative_select(CMP, MD_CMP_CFG1_INNSEL_VRESINT);
    md_cmp1_set_input_positive_select(CMP, MD_CMP_CFG1_INPSEL_PA04);
}

/**
  * @brief  main.
  * @param  None
  * @retval None
  */
int main(void)
{
    __disable_irq();

    md_rcu_pll_config(MD_RCU_PLLSRC_HRC, MD_RCU_PLLCLK_72M);
    md_rcu_clock_config(MD_RCU_SW_SYSCLK_PLL, 72000000U);

    md_rcu_enable_cmp(RCU);
    md_rcu_enable_gpioa(RCU);

    md_tick_init(MD_SYSTICK_CLKSRC_HCLK);
    md_init_1ms_tick();

    __enable_irq();

    cmp_pin_init();
    cmp_init();

    while (1)
    {
        if (md_cmp1_get_output_level(CMP) == MD_CMP_CFG_VALUE_OUTPUT_HIGH_LEVEL)
        {
            md_gpio_set_pin_high(LED2_PORT, LED2_PIN);
            md_gpio_set_pin_low(LED1_PORT, LED1_PIN);
        }
        else
        {
            md_gpio_set_pin_high(LED1_PORT, LED1_PIN);
            md_gpio_set_pin_low(LED2_PORT, LED2_PIN);
        }
    }
}

/**
  * @} Projects_Examples_MD
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
