/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    10 May 2024
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          10 May 2024     Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#define MAIN_GLOBALS

/* Includes ------------------------------------------------------------------ */
#include <stdio.h>
#include "main.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/** @addtogroup Projects_Examples_MD
  * @{
  */

/**
  * @brief  Initializate pin of can module.
  * @retval None
  */
static void can_pin_init(void)
{
    md_gpio_init_t l_gpio;
    md_gpio_init_struct(&l_gpio);

    l_gpio.mode  = MD_GPIO_MODE_FUNCTION;
    l_gpio.odos  = MD_GPIO_PUSH_PULL;
    l_gpio.pupd  = MD_GPIO_PUSH_UP;
    l_gpio.odrv  = MD_GPIO_DRIVING_8MA;
    l_gpio.flt   = MD_GPIO_FILTER_DISABLE;
    l_gpio.type  = MD_GPIO_TYPE_CMOS;
    l_gpio.func  = MD_GPIO_FUNC_0;
    md_gpio_init(CAN_TX_PORT, CAN_TX_PIN, &l_gpio);
    md_gpio_init(CAN_RX_PORT, CAN_RX_PIN, &l_gpio);
}

/**
  * @brief  main.
  * @param  None
  * @retval None
  */
int main(void)
{
    uint8_t i;
    md_can_init_typedef can_init;
    md_can_filter_config_typedef filter_config;
    md_can_txmailbox_typedef txmailbox;
    md_can_rxmailbox_typedef rxmailbox;

    __disable_irq();

    md_rcu_pll_config(MD_RCU_PLLSRC_HRC, MD_RCU_PLLCLK_72M);
    md_rcu_clock_config(MD_RCU_SW_SYSCLK_PLL, 72000000U);

    /* Initialize SysTick Interrupt */
    md_tick_init(MD_SYSTICK_CLKSRC_HCLK);
    md_init_1ms_tick();

    __enable_irq();

    md_rcu_enable_gpioc(RCU);
    md_rcu_enable_can1(RCU);

    can_pin_init();

    /* bit time baudrate 750KBit/s */
    can_init.bit_time.bpsc = 5;
    can_init.bit_time.seg1 = 12;
    can_init.bit_time.seg2 = 1;
    can_init.bit_time.resjw = 0;
    md_can_init(CAN1, &can_init);

    md_can_debugmode_config(CAN1, NORMAL_DEBUGMODE);

    filter_config.filter_fifo_assign = MD_CAN_FILTER_ASSIGN_RXFIFO1;
    filter_config.filter_mode = MD_CAN_FILTER_MOD_MASK;
    filter_config.filter_width = MD_CAN_FILTER_SEL_32BIT;
    filter_config.filter_mode_select.identifier_32bit_mask.id = 0x555;
    filter_config.filter_mode_select.identifier_32bit_mask.id_type = STANDARD_IDENTIFIER;
    filter_config.filter_mode_select.identifier_32bit_mask.frame_type = DATA_FRAME;
    filter_config.filter_mode_select.identifier_32bit_mask.mask = 0xFFDFFFFF;
    md_can_filter_config(CAN1, MD_CAN_FILTER_1, &filter_config);

    md_can_set_go(CAN1, MD_CAN_FILTER_1, MD_CAN_FILTER_ACTIVE);

    while (1)
    {
        while (md_can_get_rxfifo1_pending_count(CAN1) == 0);

        md_can_receive(CAN1, FIFO1, &rxmailbox);

        for (i = 0; i < rxmailbox.length; i++)
            txmailbox.data[i] = rxmailbox.data[i] + 1;

        txmailbox.id = rxmailbox.id;
        txmailbox.id_type = rxmailbox.id_type;
        txmailbox.frame_type = rxmailbox.frame_type;
        txmailbox.length = rxmailbox.length;

        md_can_send(CAN1, &txmailbox);

        while (md_can_is_active_flag_mailbox0_request_complete(CAN1) == 0);
    }
}

/**
  * @} Projects_Examples_MD
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/


