/**********************************************************************************
 *
 * @file    main.h
 * @brief   header file of main.c
 *
 * @date    25 July 2024
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2024    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __MAIN_H__
#define   __MAIN_H__
/* Includes ------------------------------------------------------------------ */
#include <stdio.h>
#include <string.h>
#include "md_conf.h"

/* Exported Macros ----------------------------------------------------------- */
#define ADC12_CHANNEL0_PIN             MD_GPIO_PIN_0
#define ADC12_CHANNEL0_GPIO_PORT       GPIOA
#define ADC12_CHANNEL1_PIN             MD_GPIO_PIN_1
#define ADC12_CHANNEL1_GPIO_PORT       GPIOA
#define ADC12_CHANNEL2_PIN             MD_GPIO_PIN_2
#define ADC12_CHANNEL2_GPIO_PORT       GPIOA
#define ADC12_CHANNEL3_PIN             MD_GPIO_PIN_3
#define ADC12_CHANNEL3_GPIO_PORT       GPIOA

#define VDD 3300 /* 根据实际VDD值变化，单位mV */

/* Exported Types ------------------------------------------------------------ */
/* Exported Variables -------------------------------------------------------- */
extern uint8_t g_dma_flag;

/* Exported Constants -------------------------------------------------------- */
/* Exported Functions -------------------------------------------------------- */
#endif  /* __MAIN_H__ */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
