/**********************************************************************************
 *
 * @file    main.h
 * @brief   Header file for DEMO
 *
 * @date    30 Oct 2024
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Oct 2024     AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __MAIN_H__
#define   __MAIN_H__

/* Includes ------------------------------------------------------------------ */
#include <stdio.h>
#include "md_conf.h"
#include "exec_proc.h"
#include "comm_proc.h"
#include "micro_boot.h"

/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */

/* Exported Variables -------------------------------------------------------- */
extern volatile uint32_t TmrSystem;
extern uint8_t gu8DispTital;

/* Exported Types ------------------------------------------------------------ */

/* Exported Macros ----------------------------------------------------------- */
#define __USE_CRC32
#define APP_ADDR        0x3000
#define BOOT_ADDR       0x0000
#define GO_APP          0xFFFFFFFE
#define GO_BOOT         0xFFFFFFFD
#define APP_ADDR_PAGE  (APP_ADDR/MD_FC_PC_EF_MPAGESZ)

#ifdef  __USE_CRC32
    #define CRC_CAL_ADDR    0x0006000
#endif

#define UART_TX_PORT   GPIOB
#define UART_TX_PIN    MD_GPIO_PIN_7
#define UART_RX_PORT   GPIOB
#define UART_RX_PIN    MD_GPIO_PIN_8

#define DEBUG_UART_TX_PORT   GPIOC
#define DEBUG_UART_TX_PIN    MD_GPIO_PIN_1
#define DEBUG_UART_RX_PORT   GPIOC
#define DEBUG_UART_RX_PIN    MD_GPIO_PIN_0

#define LED_1_PORT GPIOA
#define LED_1_PIN MD_GPIO_PIN_5

#define LED_2_PORT GPIOA
#define LED_2_PIN MD_GPIO_PIN_6

#define LED_3_PORT GPIOA
#define LED_3_PIN MD_GPIO_PIN_7

#define LED_4_PORT GPIOB
#define LED_4_PIN MD_GPIO_PIN_11

#define cal_TimeTick(time,sys_time)  ((time)>(sys_time)?0xffffffff-(time)+1+(sys_time):(sys_time)-(time))  // 10ms Time tick
#define cal_usTick(time,sys_time)    ((time)>(sys_time)?0xffff-(time)+1+(sys_time):(sys_time)-(time))      // 1us Time tick
#define GetSystemTime()              (TmrSystem)

#define CheckTime(time)    cal_TimeTick(time,TmrSystem)
#define UpdateTime(time)  ((time)=TmrSystem)
/* Public Functions -----------------------------------------------------------*/

#endif  /* */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
