/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for demo
  *
  * @version V1.0
  * @date    26 Apr 2021
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Apr 2021     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */

#include <string.h>
#include "main.h"

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  I2C Initialize struct
  */
md_i2c_init_t i2c_h;

/**
  * @brief  Initializate pin of i2c module.
  * @retval None
  */
void i2c_pin_init(void)
{
    md_gpio_init_t a;

    /* Initialize scl pin */
    a.mode  = MD_GPIO_MODE_OUTPUT;
    a.odos  = MD_GPIO_PUSH_PULL;
    a.pupd  = MD_GPIO_PUSH_UP;
    a.podrv = MD_GPIO_OUT_DRIVE_6;
    a.nodrv = MD_GPIO_OUT_DRIVE_6;
    a.flt   = MD_GPIO_FILTER_DISABLE;
    a.type  = MD_GPIO_TYPE_CMOS;
    a.func  = MD_GPIO_FUNC_5;
    md_gpio_init(I2C1_SCL_PORT, I2C1_SCL_PIN, &a);

    /* Initialize sda pin */
    a.mode  = MD_GPIO_MODE_OUTPUT;
    a.odos  = MD_GPIO_PUSH_PULL;
    a.pupd  = MD_GPIO_PUSH_UP;
    a.podrv = MD_GPIO_OUT_DRIVE_6;
    a.nodrv = MD_GPIO_OUT_DRIVE_6;
    a.flt   = MD_GPIO_FILTER_DISABLE;
    a.type  = MD_GPIO_TYPE_CMOS;
    a.func  = MD_GPIO_FUNC_5;
    md_gpio_init(I2C1_SDA_PORT, I2C1_SDA_PIN, &a);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    /* Initialize 1ms tick */
    md_init_1ms_tick();
    /* Enable all peripherals clock */
    md_cmu_perh_clock_config(MD_CMU_PERH_ALL, ENABLE);
    /* Initialize pin */
    i2c_pin_init();

    /* Initialize i2c */
    md_i2c_struct_init(&i2c_h);
    md_i2c_init(I2C1, &i2c_h);

    md_i2c_generate_start_condition(I2C1);
    md_i2c_transmit_data8(I2C1, 0xA0);
    md_i2c_generate_stop_condition_by_master(I2C1);

    while (1)
    {
        md_delay_1ms(1000);
    }
}
/**
  * @}
  */
/**
  * @}
  */
