/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Apr 2021
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Apr 2021     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */


#include "main.h"

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

uint8_t flag = 0;

/**
  * @brief  Initialize pin
  * @retval None
  */
void pin_init(void)
{
    md_gpio_init_t x;

    /* Initialize pin */
    x.mode  = MD_GPIO_MODE_INPUT;
    x.odos  = MD_GPIO_PUSH_PULL;
    x.pupd  = MD_GPIO_PUSH_UP;
    x.podrv = MD_GPIO_OUT_DRIVE_6;
    x.nodrv = MD_GPIO_OUT_DRIVE_6;
    x.flt   = MD_GPIO_FILTER_DISABLE;
    x.type  = MD_GPIO_TYPE_TTL;
    x.func  = MD_GPIO_FUNC_1;
    md_gpio_init(GPIO_EXTI_PORT, GPIO_EXTI_PIN, &x);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    /* Initialize SysTick */
    md_init_1ms_tick();
    /* Enable all peripherals clock */
    md_cmu_perh_clock_config(MD_CMU_PERH_ALL, ENABLE);
    /* Enable gpio interrupt */
    md_mcu_irq_config(EXTI0_3_IRQn, 3, ENABLE);
    /* Initialize pin */
    pin_init();

    /* Configure filter */
    md_gpio_interrupt_filter_enable(GPIO_EXTI_PIN);
    md_giop_interrupt_filter_clock_select(0);
    md_giop_interrupt_filter_time_set(10);
    md_gpio_enable_trailing_edge_trigger(GPIO_EXTI_PIN);
    /* Enable external interrupt */
    md_gpio_set_interrupt_port(GPIO_EXTI_PORT, GPIO_EXTI_PIN);
    md_gpio_clear_flag(GPIO_EXTI_PIN);
    md_gpio_enable_external_interrupt(GPIO_EXTI_PIN);

    while (1)
    {
        md_delay_1ms(100);
    }
}

/**
  * @}
  */
/**
  * @}
  */
