/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Apr 2021
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Apr 2021     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */

#include "main.h"
#include <string.h>


/** @addtogroup Projects_Examples_MD
  * @{
  */


/** @addtogroup Public_Function
  * @{
  */

md_crc_init_t init;
uint32_t result = 0;

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    uint16_t i = 0;
    uint8_t crc_buf[8] = {1, 2, 3, 4, 5, 6, 7, 8};

    /* Initialize ALD */
    md_init_1ms_tick();
    /* Enable all peripherals clock */
    md_cmu_perh_clock_config(MD_CMU_PERH_ALL, ENABLE);

    /* Clear crc_handle_t structure */
    memset(&init, 0x0, sizeof(md_crc_init_t));

    /* Initialize CRC */
    md_crc_init_struct(&init);
    md_crc_init(&init);
    /* Enable CRC */
    md_crc_enable(CRC);

    for (i = 0; i < 8; i++)
        md_crc_write_data(CRC, crc_buf[i]);

    /* start calculate and result is 0x76AC */
    result = md_crc_get_check_result(CRC);

    while (1)
    {
        md_delay_1ms(1000);
    }
}


/**
  * @} Public_Function_CRC
  */

/**
  * @} Projects_Examples_ALD
  */
