/**
  *********************************************************************************
  *
  * @file    irq.c
  * @brief   Interrupt handler
  *
  * @version V1.0
  * @date    26 Apr 2021
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Apr 2021     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */

#include "main.h"


/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  NMI IRQ handler
  * @retval None
  */
void NMI_Handler(void)
{
    /* Added Emergency operation */
    return;
}

/**
  * @brief  Hardfault IRQ handler
  * @retval None
  */
void HardFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  Supervisor Call IRQ handler
  * @retval None
  */
void SVC_Handler(void)
{
    /* Added system callback */
    return;
}

/**
  * @brief  Debug Monitor IRQ handler
  * @retval None
  */
void DebugMon_Handler(void)
{
    /* Added debug operation */
    return;
}

/**
  * @brief  PendSV IRQ handler
  * @retval None
  */
void PendSV_Handler(void)
{
    /* Added thread switching operation */
    return;
}

/**
  * @brief  SysTick IRQ handler
  * @retval None
  */
void SysTick_Handler(void)
{
    ald_inc_tick();
    return;
}


/**
  * @brief  DMA IRQ#9 handler
  * @retval None
  */
void DMA_Handler(void)
{
    if (DMA0->IFLAG & (0x1 << SPI_TX_DMA_CH))
    {
        DMA0->CHENCLR = (0x1 << SPI_TX_DMA_CH);
        DMA0->ICFR    = (0x1 << SPI_TX_DMA_CH);
        CLEAR_BIT(h_spi.perh->CON2, SPI_CON2_TXDMA_MSK);

        only_tx_flag = 1;
    }

    if (DMA0->IFLAG & (0x1 << SPI_RX_DMA_CH))
    {
        DMA0->CHENCLR = (0x1 << SPI_RX_DMA_CH);
        DMA0->ICFR    = (0x1 << SPI_RX_DMA_CH);
        CLEAR_BIT(h_spi.perh->CON2, SPI_CON2_RXDMA_MSK);

        tx_rx_flag = 1;
    }
}


/**
  * @brief SPI0_IRQHandler.
  * @retval none
  */
void SPI0_Handler(void)
{
    ald_spi_irq_handler(&h_spi);
}
/**
  * @}
  */

/**
  * @}
  */
