/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Apr 2021
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Apr 2021     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */

#include <string.h>
#include "main.h"
#include "ald_pmu.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

rtc_time_t time;
rtc_date_t date;
uint8_t temp[16];
uint32_t idx = 0;


/**
  * @brief  Test RTC time and date functions
  * @retval Status.
  */
int main()
{
    rtc_init_t init;

    /* Initialize ALD */
    ald_cmu_init();
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);
    /* Select RTC clock source */
    ald_rtc_source_select(RTC_SOURCE_HRC_DIV_1M);
    /* Enable RTC interrupt */
    ald_mcu_irq_config(RTC_IRQn, 0, ENABLE);
    /* Enable HRC in low power mode */
    CMU_LP_HRC_ENABLE();

    /* Initialize RTC */
    init.asynch_pre_div  = 32;
    init.synch_pre_div   = 31249;
    init.hour_format     = RTC_HOUR_FORMAT_24;
    init.output          = RTC_OUTPUT_DISABLE;
    init.output_polarity = RTC_OUTPUT_POLARITY_HIGH;
    ald_rtc_init(&init);

    /* Set current time and date */
    time.hour    = 21;
    time.minute  = 22;
    time.second  = 38;
    time.sub_sec = 123;
    date.day     = 11;
    date.month   = 9;
    date.year    = 17;
    date.week    = 1;

    if ((ald_rtc_set_time(&time, RTC_FORMAT_DEC)) != OK)
        return -1;

    if ((ald_rtc_set_date(&date, RTC_FORMAT_DEC)) != OK)
        return -2;

    ald_rtc_set_wakeup(RTC_WAKEUP_CLOCK_DIV_16, 31249);
    ald_rtc_interrupt_config(RTC_IT_WU, ENABLE);

    while (1)
    {
        ald_pmu_stop1_enter();
    }
}

/**
  * @brief  RTC IRQ handler
  * @retval None
  */
void rtc_irq_handler(void)
{
    ald_rtc_get_time(&time, RTC_FORMAT_DEC);
    temp[idx++] = time.second;
    idx = idx == 16 ? 0 : idx;

    ald_rtc_get_flag_status(RTC_IF_WU);
    ald_rtc_clear_flag_status(RTC_IF_WU);

    return;
}
/**
  * @}
  */
/**
  * @}
  */
