/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Apr 2021
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Apr 2021     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

rtc_time_t time;
rtc_date_t date;

/**
  * @brief  Initialize rtc pin
  * @retval None
  */
void rtc_pin_init(void)
{
    gpio_init_t x;

    /* Initialize RTCO #0 pin */
    x.mode  = GPIO_MODE_OUTPUT;
    x.odos  = GPIO_PUSH_PULL;
    x.pupd  = GPIO_PUSH_UP;
    x.flt   = GPIO_FILTER_DISABLE;
    x.type  = GPIO_TYPE_TTL;
    x.nodrv = GPIO_OUT_DRIVE_6;
    x.podrv = GPIO_OUT_DRIVE_6;
    x.func  = GPIO_FUNC_3;
    ald_gpio_init(RTC_CLKOUTPUT_PORT, RTC_CLKOUTPUT_PIN, &x);
}

/**
  * @brief  Test RTC time and date functions
  * @retval Status.
  */
int main()
{
    rtc_init_t init;

    /* Initialize ALD */
    ald_cmu_init();
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);
    /* Select RTC clock source */
    ald_rtc_source_select(RTC_SOURCE_LOSM);

    rtc_pin_init();
    /* Enable RTC interrupt */
    ald_mcu_irq_config(RTC_IRQn, 0, ENABLE);

    /* Initialize RTC */
    init.asynch_pre_div  = 0;
    init.synch_pre_div   = 32767;
    init.hour_format     = RTC_HOUR_FORMAT_24;
    init.output          = RTC_OUTPUT_DISABLE;
    init.output_polarity = RTC_OUTPUT_POLARITY_HIGH;
    ald_rtc_init(&init);

    /* Set current time and date */
    time.hour    = 21;
    time.minute  = 22;
    time.second  = 43;
    time.sub_sec = 123;
    date.day     = 11;
    date.month   = 9;
    date.year    = 17;
    date.week    = 1;

    if ((ald_rtc_set_time(&time, RTC_FORMAT_DEC)) != OK)
        return -1;

    if ((ald_rtc_set_date(&date, RTC_FORMAT_DEC)) != OK)
        return -2;

    /* Configure tamper parameters */
    ald_rtc_set_clock_output(RTC_CLOCK_OUTPUT_1);

    while (1)
    {
        ald_delay_ms(1000);
    }
}
/**
  * @}
  */
/**
  * @}
  */
