/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0.1
  * @date    28 Apr 2022
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Apr 2021     AE Team         The first version
  *          28 Apr 2022     AE Team         modify the system clock
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */

#include <string.h>
#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

lpuart_handle_t h_lpuart;
uint8_t _flag;
uint16_t rx_data_len;
uint8_t tx_buf[8];
uint8_t rx_buf[32];

/**
  * @brief  Initializate pin of uart module.
  * @retval None
  */
void lpuart_pin_init(void)
{
    gpio_init_t x;

    /* Initialize tx pin */
    x.mode = GPIO_MODE_OUTPUT;
    x.odos = GPIO_PUSH_PULL;
    x.pupd = GPIO_PUSH_UP;
    x.podrv = GPIO_OUT_DRIVE_1;
    x.nodrv = GPIO_OUT_DRIVE_0_1;
    x.flt  = GPIO_FILTER_DISABLE;
    x.type = GPIO_TYPE_TTL;
    x.func = GPIO_FUNC_4;
    ald_gpio_init(GPIOB, GPIO_PIN_10, &x);

    /* Initialize rx pin */
    x.mode = GPIO_MODE_INPUT;
    x.odos = GPIO_PUSH_PULL;
    x.pupd = GPIO_PUSH_UP;
    x.podrv = GPIO_OUT_DRIVE_1;
    x.nodrv = GPIO_OUT_DRIVE_0_1;
    x.flt  = GPIO_FILTER_DISABLE;
    x.type = GPIO_TYPE_TTL;
    x.func = GPIO_FUNC_4;
    ald_gpio_init(GPIOB, GPIO_PIN_11, &x);

    /* Initialize rts pin */
    x.mode = GPIO_MODE_OUTPUT;
    x.odos = GPIO_PUSH_PULL;
    x.pupd = GPIO_PUSH_UP;
    x.podrv = GPIO_OUT_DRIVE_1;
    x.nodrv = GPIO_OUT_DRIVE_0_1;
    x.flt  = GPIO_FILTER_DISABLE;
    x.type = GPIO_TYPE_TTL;
    x.func = GPIO_FUNC_4;
    ald_gpio_init(GPIOB, GPIO_PIN_12, &x);

    /* Initialize cts pin */
    x.mode = GPIO_MODE_INPUT;
    x.odos = GPIO_PUSH_PULL;
    x.pupd = GPIO_PUSH_UP;
    x.podrv = GPIO_OUT_DRIVE_1;
    x.nodrv = GPIO_OUT_DRIVE_0_1;
    x.flt  = GPIO_FILTER_DISABLE;
    x.type = GPIO_TYPE_TTL;
    x.func = GPIO_FUNC_4;
    ald_gpio_init(GPIOB, GPIO_PIN_13, &x);

    return;
}

/**
  * @brief  Send message complete.
  * @param  arg: Pointer to uart_handle_t structure.
  * @retval None.
  */
void lpuart_send_complete(lpuart_handle_t *arg)
{
    return;
}

/**
  * @brief  Receive a message complete.
  * @param  arg: Pointer to uart_handle_t structure.
  * @retval None.
  */
void lpuart_recv_complete(lpuart_handle_t *arg)
{
    _flag = 0x1;
    rx_data_len = arg->rx_count;

    return;
}

/**
  * @brief  Occurs error.
  * @param  arg: Pointer to uart_handle_t structure.
  * @retval None.
  */
void lpuart_error(lpuart_handle_t *arg)
{
    return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    /* Initialize ALD */
    ald_cmu_init();
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

    /* clear uart_handle_t structure */
    memset(&h_lpuart, 0x0, sizeof(h_lpuart));

    /* Initialize pin */
    lpuart_pin_init();

    /* Initialize tx_buf */
    memset(tx_buf, 0x55, sizeof(tx_buf));
    _flag = 0x0;

    /* Initialize uart */
    h_lpuart.perh             = LPUART0;
    h_lpuart.init.baud        = 9600;
    h_lpuart.init.word_length = LPUART_WORD_LENGTH_8B;
    h_lpuart.init.stop_bits   = LPUART_STOP_BITS_1;
    h_lpuart.init.parity      = LPUART_PARITY_NONE;
    h_lpuart.init.mode        = LPUART_MODE_UART;
    h_lpuart.init.fctl        = LPUART_HW_FLOW_CTL_NONE;
    h_lpuart.tx_cplt_cbk      = lpuart_send_complete;
    h_lpuart.rx_cplt_cbk      = lpuart_recv_complete;
    h_lpuart.error_cbk        = lpuart_error;
    ald_lpuart_init(&h_lpuart);
    ald_mcu_irq_config(LPUART0_IRQn, 3, ENABLE);

    /* Send a message */
    ald_lpuart_send_by_it(&h_lpuart, tx_buf, 8);
    /* Receive a message, Max-length: 32-bytes */
    ald_lpuart_recv_frame_by_it(&h_lpuart, rx_buf, 32, 20);

    while (1) {
        if (_flag) {
            _flag = 0x0;
            /* Receive a message, Max-length: 32-bytes */
            ald_lpuart_recv_frame_by_it(&h_lpuart, rx_buf, 32, 20);
	}
    }
}

/**
  * @}
  */
/**
  * @}
  */
