/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Apr 2021
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Apr 2021     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

lptim_handle_t h_lptim;

/**
  * @brief  Initializate pin of lptim module.
  * @retval None
  */
void lptim_pin_init(void)
{
    gpio_init_t x;
    pis_handle_t y;

    /* Initialize PB5 as output */
    x.mode  = GPIO_MODE_OUTPUT;
    x.odos  = GPIO_PUSH_PULL;
    x.pupd  = GPIO_PUSH_UP;
    x.flt   = GPIO_FILTER_DISABLE;
    x.type  = GPIO_TYPE_TTL;
    x.nodrv = GPIO_OUT_DRIVE_6;
    x.podrv = GPIO_OUT_DRIVE_6;
    x.func  = GPIO_FUNC_3;
    ald_gpio_init(GPIOB, GPIO_PIN_5, &x);

    /* Initialize PB2 as input */
    x.mode  = GPIO_MODE_INPUT;
    x.odos  = GPIO_PUSH_PULL;
    x.pupd  = GPIO_PUSH_DOWN;
    x.flt   = GPIO_FILTER_DISABLE;
    x.type  = GPIO_TYPE_TTL;
    x.nodrv = GPIO_OUT_DRIVE_6;
    x.podrv = GPIO_OUT_DRIVE_6;
    x.func  = GPIO_FUNC_1;
    ald_gpio_init(GPIOB, GPIO_PIN_2, &x);

    y.perh               = PIS;
    y.init.producer_src  = PIS_GPIO_PIN2;
    y.init.producer_clk  = PIS_CLK_PCLK1;
    y.init.producer_edge = PIS_EDGE_NONE;
    y.init.consumer_trig = PIS_CH0_L16T0_EXT0;
    y.init.consumer_clk  = PIS_CLK_PCLK1;
    ald_pis_create(&y);
}
/**
  * @brief  Compare complete.
  * @param  arg: Pointer to lptim_handle_t structure.
  * @retval None.
  */
void compare_complete(lptim_handle_t *arg)
{
    return;
}

/**
  * @brief  updata complete.
  * @param  arg: Pointer to lptim_handle_t structure.
  * @retval None.
  */
void updata_complete(lptim_handle_t *arg)
{
    return;
}

/**
  * @brief  External trigger complete.
  * @param  arg: Pointer to lptim_handle_t structure.
  * @retval None.
  */
void external_trigger_complete(lptim_handle_t *arg)
{
    return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    lptim_clock_source_init_t conf;
    lptim_trigger_init_t  trig;

    /* Initialize ALD */
    ald_cmu_init();
    /* Configure system clock */
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
    /* Enable all peripherals */
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

    /* Enable LP16T0 interrupt */
    ald_mcu_irq_config(LP16T0_IRQn, 3, ENABLE);
    /* Initialize pin */
    lptim_pin_init();

    /* Initialize LPTIM0 */
    h_lptim.perh       = LPTIM0;
    h_lptim.init.psc   = LPTIM_PRESC_128;
    h_lptim.init.mode  = LPTIM_MODE_CONTINUOUS;
    h_lptim.init.arr   = 1000;
    h_lptim.init.cmp   = 100;
    h_lptim.init.clock = CMU_LP_PERH_CLOCK_SEL_HRC;
    h_lptim.trig_cbk   = external_trigger_complete;
    h_lptim.update_cbk = updata_complete;
    h_lptim.cmp_cbk    = compare_complete;
    ald_lptim_toggle_init(&h_lptim);

    /* Initialize clock source */
    conf.sel      = LPTIM_CKSEL_INTERNAL;
    conf.polarity = LPTIM_CKPOL_RISING;
    ald_lptim_clock_source_config(&h_lptim, &conf);

    /* Initialize pulse */
    trig.mode = LPTIM_TRIGEN_RISING;
    trig.sel  = LPTIM_TRIGSEL_EXT0;
    ald_lptim_trigger_config(&h_lptim, &trig);

    ald_lptim_interrupt_config(&h_lptim, LPTIM_IT_EXTTRIG, ENABLE);
    /* Start pulse start */
    ald_lptim_toggle_start(&h_lptim);

    while (1)
    {
        ald_delay_ms(1000);
    }
}
/**
  * @}
  */
/**
  * @}
  */
